/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.data.resultSetViewer;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTMessageKeys;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTODPException;
import com.cognos.xqe.data.providers.olap.tm1rest.data.resultSetViewer.TM1RESTAxis;
import com.cognos.xqe.data.providers.olap.tm1rest.data.resultSetViewer.TM1RESTCell;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonArray;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonObject;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClient;
import com.cognos.xqe.data.providers.olap.tm1rest.utils.RESTUriBuilder;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.trace.LogLevel;
import java.util.ArrayList;
import java.util.List;

public class BasicTM1RESTResultSet {
    private static final String REST_CLIENT = ", RESTClient: ";
    private static final String CELL_SET_ID = "CellSetID: ";
    private static final String RESULT_SET = "ResultSet";
    public static final String AXES_COLON = "Axes:";
    public static final String CELLS_COLON = "Cells:";
    public static final String NUMBER_OF_CELLS = "Number of cells";
    private final String cellSetId;
    private List<TM1RESTCell> cellList;
    private TM1RESTAxis[] axisArray;
    RESTClient restClient;
    private final ExecutionEnvironment execEnvironment;

    public BasicTM1RESTResultSet(String aCellSetId, RESTClient aRestClient, ExecutionEnvironment aExecEnvironment) {
        this.cellSetId = aCellSetId;
        this.restClient = aRestClient;
        this.cellList = null;
        this.axisArray = null;
        this.execEnvironment = aExecEnvironment;
    }

    public void initialize(LogLevel axisLogLevel, LogLevel cellsLogLevel) {
        try {
            if (axisLogLevel == LogLevel.INFO || axisLogLevel == LogLevel.TRACE) {
                String axesUri = RESTUriBuilder.getAxesUri(this.cellSetId, this.restClient.getUriBuilder());
                IJsonObject jsonAxisSet = this.restClient.getJsonResource(axesUri, this.execEnvironment);
                IJsonArray jsonAxisArray = jsonAxisSet.getArray("value");
                this.axisArray = new TM1RESTAxis[jsonAxisArray.size()];
                int i = 0;
                for (Object obj : jsonAxisArray) {
                    this.axisArray[i++] = new TM1RESTAxis((IJsonObject)obj, this.restClient, this.cellSetId, this.execEnvironment);
                }
            }
            if (cellsLogLevel == LogLevel.INFO) {
                String cellSetsUri = RESTUriBuilder.getCellSetsUri(this.cellSetId, this.restClient.getUriBuilder());
                IJsonObject jsonCellSet = this.restClient.getJsonResource(cellSetsUri, this.execEnvironment);
                IJsonArray jsonCellArray = jsonCellSet.getArray("value");
                this.cellList = new ArrayList<TM1RESTCell>();
                for (Object cell : jsonCellArray) {
                    this.cellList.add(new TM1RESTCell((IJsonObject)cell));
                }
            }
            if (cellsLogLevel == LogLevel.TRACE) {
                IJsonObject jsonCellSet;
                XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
                Boolean logTM1RESTFormattedValue = configuration.getBooleanProperty("queryExecution.logTM1RESTFormattedValue[@enabled]", false);
                if (logTM1RESTFormattedValue.booleanValue()) {
                    String cellSetsUriWithFormattedValue = RESTUriBuilder.getCellSetsUriWithFormattedValue(this.cellSetId, this.restClient.getUriBuilder());
                    jsonCellSet = this.restClient.getJsonResource(cellSetsUriWithFormattedValue, this.execEnvironment);
                } else {
                    String cellSetsUri = RESTUriBuilder.getCellSetsUri(this.cellSetId, this.restClient.getUriBuilder());
                    jsonCellSet = this.restClient.getJsonResource(cellSetsUri, this.execEnvironment);
                }
                IJsonArray jsonCellArray = jsonCellSet.getArray("value");
                this.cellList = new ArrayList<TM1RESTCell>();
                for (Object cell : jsonCellArray) {
                    this.cellList.add(new TM1RESTCell((IJsonObject)cell));
                }
            }
        }
        catch (Exception e) {
            throw new TM1RESTODPException(TM1RESTMessageKeys.ERR_UNKNOWN_TM1_ERROR_WITH_MESSAGE, e.getLocalizedMessage());
        }
    }

    public TM1RESTAxis[] getAxisArray() {
        return this.axisArray;
    }

    public List<TM1RESTCell> getCellList() {
        return this.cellList;
    }

    public String axesToString(LogLevel axisLogLevel) {
        if (axisLogLevel != LogLevel.INFO && axisLogLevel != LogLevel.TRACE) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        this.axesToString(axisLogLevel, sb);
        return sb.toString();
    }

    private void axesToString(LogLevel axisLogLevel, StringBuilder sb) {
        sb.append("\n");
        sb.append(AXES_COLON).append("{");
        sb.append("\n");
        if (this.getAxisArray() != null) {
            for (TM1RESTAxis currAxis : this.getAxisArray()) {
                sb.append(currAxis.toString(axisLogLevel, "  "));
                if (currAxis == this.getAxisArray()[this.getAxisArray().length - 1]) continue;
                sb.append(",").append("\n");
            }
        }
        sb.append("}");
    }

    public String cellsToString(LogLevel cellsLogLevel) {
        if (cellsLogLevel != LogLevel.INFO && cellsLogLevel != LogLevel.TRACE) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        this.cellsToString(cellsLogLevel, sb);
        return sb.toString();
    }

    private void cellsToString(LogLevel cellsLogLevel, StringBuilder sb) {
        sb.append("\n");
        sb.append(CELLS_COLON).append("{").append(" ");
        if (this.getCellList() != null) {
            sb.append(NUMBER_OF_CELLS).append("=").append(this.getCellList().size());
            if (cellsLogLevel == LogLevel.TRACE) {
                for (TM1RESTCell currCell : this.getCellList()) {
                    sb.append("\n");
                    sb.append(currCell.toString("  "));
                }
            }
        }
        sb.append("}");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\n");
        sb.append(RESULT_SET);
        sb.append("(").append(" ").append(CELL_SET_ID).append(this.cellSetId).append(REST_CLIENT).append(this.restClient.toString()).append(")");
        sb.append(" ").append("{");
        this.axesToString(LogLevel.TRACE, sb);
        this.cellsToString(LogLevel.TRACE, sb);
        sb.append("\n").append("}");
        return sb.toString();
    }
}

