/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.data.resultSetViewer;

import com.cognos.xqe.data.providers.olap.tm1rest.data.TM1RESTCellIterator;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonObject;
import com.cognos.xqe.data.types.BooleanType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.DoubleType;
import com.cognos.xqe.data.types.LongType;
import com.cognos.xqe.data.types.StringType;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;

public class TM1RESTCell {
    private static final String CELL = "Cell";
    private long ordinal;
    private final TM1RESTCellIterator.CellStatus status;
    private final String formatString;
    private final String formattedValue;
    private final Value value;
    private final Boolean ruleDerived;

    public TM1RESTCell(IJsonObject cell) {
        this.ordinal = cell.getLongValue("Ordinal");
        this.status = TM1RESTCellIterator.CellStatus.strToCellStatus(cell.getStringValue("Status"));
        this.formatString = cell.getStringValue("FormatString");
        this.formattedValue = cell.getStringValue("FormattedValue");
        Object tm1Value = cell.getObject("Value");
        this.ruleDerived = cell.getBooleanValue("RuleDerived");
        if (this.status == TM1RESTCellIterator.CellStatus.Null) {
            StringType dataType = DataTypeFactory.getStringType();
            this.value = (Value)dataType.createValue();
            this.value.set(tm1Value);
            this.value.setState(ValueState.NULL);
        } else if (this.status == TM1RESTCellIterator.CellStatus.Data) {
            if (tm1Value instanceof Boolean) {
                BooleanType dataType = DataTypeFactory.getBooleanType();
                this.value = (Value)dataType.createValue();
                this.value.set(tm1Value);
            } else if (tm1Value instanceof Double) {
                DoubleType dataType = DataTypeFactory.getDoubleType();
                this.value = (Value)dataType.createValue();
                this.value.set(tm1Value);
            } else if (tm1Value instanceof Long || tm1Value instanceof Integer) {
                LongType dataType = DataTypeFactory.getLongType();
                this.value = (Value)dataType.createValue();
                this.value.set(tm1Value);
            } else if (tm1Value instanceof String) {
                StringType dataType = DataTypeFactory.getStringType();
                this.value = (Value)dataType.createValue();
                this.value.set(tm1Value);
            } else {
                StringType dataType = DataTypeFactory.getStringType();
                this.value = (Value)dataType.createValue();
                this.value.set(tm1Value);
                this.value.setState(ValueState.ERROR);
            }
        } else {
            StringType dataType = DataTypeFactory.getStringType();
            this.value = (Value)dataType.createValue();
            this.value.set(tm1Value);
            this.value.setState(ValueState.ERROR);
        }
    }

    public long getOrdinal() {
        return this.ordinal;
    }

    public TM1RESTCellIterator.CellStatus getStatus() {
        return this.status;
    }

    public String getFormatString() {
        return this.formatString;
    }

    public String getFormattedValue() {
        return this.formattedValue;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isRuleDerived() {
        return this.ruleDerived;
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        if (indent != null && !indent.isEmpty()) {
            sb.append(indent);
        }
        sb.append(CELL);
        sb.append("(");
        TM1RESTCell.appendProperty(this.ordinal, "Ordinal", sb, indent);
        TM1RESTCell.appendProperty((Object)this.status, "Status", sb, indent);
        TM1RESTCell.appendProperty(this.formatString, "FormatString", sb, indent);
        TM1RESTCell.appendProperty(this.formattedValue, "FormattedValue", sb, indent);
        TM1RESTCell.appendProperty(this.value, "Value", sb, indent);
        TM1RESTCell.appendProperty(this.ruleDerived, "RuleDerived", sb, indent);
        sb.append(")");
        return sb.toString();
    }

    private static void appendProperty(Object property, String propertyName, StringBuilder sb, String indent) {
        sb.append("\n");
        if (indent != null && !indent.isEmpty()) {
            sb.append(indent + indent);
        }
        sb.append(propertyName).append("=").append(property);
    }

    public String toString() {
        return this.toString("");
    }
}

