/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.data.resultSetViewer;

import com.cognos.xqe.data.providers.olap.tm1rest.data.resultSetViewer.TM1RESTHierarchy;
import com.cognos.xqe.data.providers.olap.tm1rest.data.resultSetViewer.TM1RESTLevel;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonArray;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonObject;
import java.util.HashMap;
import java.util.Map;

public class TM1RESTMember {
    public static final String MEMBER = "Member";
    private String type = null;
    private long ordinal = -1L;
    private String uniqueName = null;
    private String name = null;
    private TM1RESTMember parent = null;
    private TM1RESTMember[] children = null;
    Map<String, Object> attributes = null;
    private TM1RESTHierarchy hierarchy = null;
    private TM1RESTLevel level = null;

    public TM1RESTMember(IJsonObject member) {
        IJsonArray jsonChildren;
        IJsonObject jsonParent;
        if (member.containsKey("Type")) {
            this.type = member.getStringValue("Type");
        }
        if (member.containsKey("Ordinal")) {
            this.ordinal = member.getLongValue("Ordinal");
        }
        if (member.containsKey("UniqueName")) {
            this.uniqueName = member.getStringValue("UniqueName");
        }
        if (member.containsKey("Name")) {
            this.name = member.getStringValue("Name");
        }
        if (member.containsKey("Attributes")) {
            this.attributes = new HashMap<String, Object>();
            IJsonObject jsonAttributes = member.getJsonObject("Attributes");
            this.attributes.putAll(jsonAttributes);
        }
        if (member.containsKey("Parent") && (jsonParent = member.getJsonObject("Parent")) != null && !jsonParent.isEmpty()) {
            this.parent = new TM1RESTMember(jsonParent);
        }
        if (member.containsKey("Children") && !(jsonChildren = member.getArray("Children")).isEmpty()) {
            this.children = new TM1RESTMember[jsonChildren.size()];
            int i = 0;
            for (Object currChild : jsonChildren) {
                if (currChild != null) {
                    this.children[i++] = new TM1RESTMember((IJsonObject)currChild);
                    continue;
                }
                this.children[i++] = null;
            }
        }
        if (member.containsKey("Hierarchy")) {
            IJsonObject jsonHierarchy = member.getJsonObject("Hierarchy");
            this.hierarchy = new TM1RESTHierarchy(jsonHierarchy);
        }
        if (member.containsKey("Level")) {
            IJsonObject jsonLevel = member.getJsonObject("Level");
            this.level = new TM1RESTLevel(jsonLevel);
        }
    }

    public String getType() {
        return this.type;
    }

    public final long getOrdinal() {
        return this.ordinal;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getAttibutes() {
        return this.attributes;
    }

    public TM1RESTMember getParent() {
        return this.parent;
    }

    public TM1RESTMember[] getChildren() {
        return this.children;
    }

    public TM1RESTHierarchy getHierarchy() {
        return this.hierarchy;
    }

    public TM1RESTLevel getLevel() {
        return this.level;
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        if (indent != null && !indent.isEmpty()) {
            sb.append(indent);
        }
        sb.append(MEMBER);
        sb.append("(");
        sb.append("\n").append(indent);
        sb.append(" ").append("Ordinal").append("=").append(this.ordinal);
        TM1RESTMember.appendStrProperty(this.type, "Type", sb, indent);
        TM1RESTMember.appendStrProperty(this.name, "Name", sb, indent);
        TM1RESTMember.appendStrProperty(this.uniqueName, "UniqueName", sb, indent);
        TM1RESTMember.appendProperty(this.attributes, "Attributes", sb, indent);
        TM1RESTMember.appendProperty(this.hierarchy, "Hierarchy", sb, indent);
        TM1RESTMember.appendProperty(this.level, "Level", sb, indent);
        if (this.parent != null) {
            TM1RESTMember.appendStrProperty(this.parent.getUniqueName(), "Parent", sb, indent);
        }
        if (this.getChildren() != null) {
            sb.append("\n").append(indent);
            sb.append(" ").append("Children").append("(").append(" ");
            int i = -1;
            for (TM1RESTMember currMember : this.getChildren()) {
                ++i;
                if (currMember != null) {
                    sb.append(currMember.getUniqueName());
                } else {
                    sb.append("NULL");
                }
                if (i >= this.getChildren().length - 1) continue;
                sb.append(",").append(" ");
            }
            sb.append(" ");
            sb.append(")");
        }
        sb.append(")");
        return sb.toString();
    }

    public static void appendStrProperty(String property, String propertyName, StringBuilder sb, String indent) {
        if (property != null && !property.isEmpty()) {
            sb.append("\n").append(indent);
            sb.append(" ").append(propertyName).append("=").append(property);
        }
    }

    private static void appendProperty(Object property, String propertyName, StringBuilder sb, String indent) {
        if (property != null) {
            sb.append("\n").append(indent);
            if (property instanceof TM1RESTHierarchy) {
                sb.append(" ").append(propertyName).append("=").append(((TM1RESTHierarchy)property).toString(indent + indent));
            } else if (property instanceof TM1RESTLevel) {
                sb.append(" ").append(propertyName).append("=").append(((TM1RESTLevel)property).toString(indent + indent));
            } else {
                sb.append(" ").append(propertyName).append("=").append(property);
            }
        }
    }

    public String toString() {
        return this.toString("");
    }
}

