/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.metadata;

import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTMessageKeys;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonObject;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Dimension;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Hierarchy;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Level;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadata;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadataType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.util.LocalizedString;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.io.PrintWriter;
import java.util.List;
import java.util.Locale;

public class TM1Attribute
extends TM1RESTMetadata {
    private static final String SPACE = " ";
    private static final String NAME = " - Name";
    private static final String NUMERIC_ATTRIBUTE_TYPE = "Numeric";
    public static final String ALIAS = "Alias";
    private final RoleTypeEnum mRole;
    private String mDescription;
    private String mType;
    private IDataType mDataType;

    public TM1Attribute(TM1Dimension dimension, RoleTypeEnum role) {
        super(dimension);
        this.mRole = role;
        this.mDataType = DataTypeFactory.getStringType();
    }

    public TM1Attribute(TM1Hierarchy hierarchy, RoleTypeEnum role) {
        super(hierarchy);
        this.mRole = role;
        this.mDataType = DataTypeFactory.getStringType();
    }

    public TM1Attribute(TM1Level level, RoleTypeEnum role) {
        super(level);
        this.mRole = role;
        this.mDataType = DataTypeFactory.getStringType();
    }

    private void setCaptions(Locale defaultLocale, List<String> locales) {
        String parentCaption = this.getParent().getLocalizedCaption().toString(defaultLocale);
        if (parentCaption == null || parentCaption.isEmpty()) {
            parentCaption = this.getParent().getCaption();
        }
        this.mCaption = parentCaption + SPACE + XQEMessages.getMessage((IMessageKey.Param0)TM1RESTMessageKeys.STR_DASH_NAME, (Locale)defaultLocale);
        this.mLocalizedCaption = new LocalizedString(defaultLocale, this.mCaption);
        for (String localeName : locales) {
            if (localeName.equals(defaultLocale.toString())) continue;
            Locale currentLocale = new Locale(localeName);
            parentCaption = this.getParent().getLocalizedCaption().toString(currentLocale);
            if (parentCaption == null || parentCaption.isEmpty()) {
                parentCaption = this.getParent().getCaption();
            }
            String localizedCaption = parentCaption + SPACE + XQEMessages.getMessage((IMessageKey.Param0)TM1RESTMessageKeys.STR_DASH_NAME, (Locale)currentLocale);
            this.mLocalizedCaption.put(localeName, localizedCaption);
        }
    }

    public static TM1Attribute createHierarchyBusinessKey(TM1Hierarchy hierarchy, Locale defaultLocale, List<String> locales) {
        TM1Attribute attribute = new TM1Attribute(hierarchy, RoleTypeEnum.BUSINESS_KEY);
        attribute.mProviderCaption = hierarchy.getName() + NAME;
        attribute.mName = "MEMBER_KEY";
        attribute.mProviderUniqueName = "MEMBER_KEY";
        attribute.mDescription = "";
        attribute.mDataType = DataTypeFactory.getStringType();
        attribute.setCaptions(defaultLocale, locales);
        return attribute;
    }

    public static TM1Attribute createLevelBusinessKey(TM1Level level, Locale defaultLocale, List<String> locales) {
        TM1Attribute attribute = new TM1Attribute(level, RoleTypeEnum.BUSINESS_KEY);
        attribute.mProviderCaption = level.getName() + NAME;
        attribute.mName = "MEMBER_KEY";
        attribute.mProviderUniqueName = "MEMBER_KEY";
        attribute.mDescription = "";
        attribute.mDataType = DataTypeFactory.getStringType();
        attribute.setCaptions(defaultLocale, locales);
        return attribute;
    }

    @Override
    public TM1RESTMetadataType getType() {
        return TM1RESTMetadataType.ATTRIBUTE;
    }

    @Override
    public String getUniqueName() {
        if (null == this.mUniqueName) {
            if (RoleTypeEnum.MEMBER_CUSTOM_PROPERTY == this.mRole && !"MEMBER_KEY".equals(this.mProviderUniqueName)) {
                StringBuilder buf = new StringBuilder(this.getDimension().getUniqueName());
                buf.append('.').append(UniqueNameGenerator.createSingleNamePart((String)this.getName()));
                this.mUniqueName = buf.toString();
            } else {
                this.mUniqueName = this.mProviderUniqueName;
            }
        }
        return this.mUniqueName;
    }

    @Override
    public void dump(PrintWriter writer, int indent) {
        TM1Attribute.printHeader(writer, indent, "TM1Attribute");
        TM1Attribute.printField(writer, indent, "name", this.getName());
        TM1Attribute.printField(writer, indent, "caption", this.getCaption());
        TM1Attribute.printField(writer, indent, "dataType", this.getDataType().toString());
        TM1Attribute.printField(writer, indent, "description", this.getDescription());
        TM1Attribute.printField(writer, indent, "role", this.getRoleType().toRoleValue());
    }

    public boolean isDimensionAttribute() {
        return TM1RESTMetadataType.DIMENSION == this.getParent().getType();
    }

    public boolean isHierarchyAttribute() {
        return TM1RESTMetadataType.HIERARCHY == this.getParent().getType();
    }

    public boolean isLevelAttribute() {
        return TM1RESTMetadataType.LEVEL == this.getParent().getType();
    }

    public boolean isAlias() {
        return ALIAS.equals(this.mType);
    }

    public TM1Dimension getDimension() {
        switch (this.getParent().getType()) {
            case DIMENSION: {
                return (TM1Dimension)this.getParent();
            }
            case HIERARCHY: {
                return ((TM1Hierarchy)this.getParent()).getDimension();
            }
            case LEVEL: {
                return ((TM1Level)this.getParent()).getHierarchy().getDimension();
            }
        }
        return null;
    }

    public TM1Hierarchy getHierarchy() {
        switch (this.getParent().getType()) {
            case HIERARCHY: {
                return (TM1Hierarchy)this.getParent();
            }
            case LEVEL: {
                return ((TM1Level)this.getParent()).getHierarchy();
            }
        }
        return null;
    }

    public TM1Level getLevel() {
        if (TM1RESTMetadataType.LEVEL == this.getParent().getType()) {
            return (TM1Level)this.getParent();
        }
        return null;
    }

    public RoleTypeEnum getRoleType() {
        return this.mRole;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getAttributeType() {
        return this.mType;
    }

    public IDataType getDataType() {
        return this.mDataType;
    }

    public void populate(IJsonObject attrObj) {
        this.mProviderUniqueName = this.mName = attrObj.getStringValue("Name");
        this.mProviderCaption = this.mName;
        this.mType = attrObj.getStringValue("Type");
        this.mDataType = NUMERIC_ATTRIBUTE_TYPE.equals(this.mType) ? DataTypeFactory.getNumericType() : DataTypeFactory.getStringType();
        this.mDescription = this.isAlias() ? "alias" : "";
    }
}

