/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.metadata;

import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1CubeTimestamps;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class TM1CubeSnapshot {
    private static final long DEFAULT_STALE_CHECK_INTERVAL = 5000L;
    private final TM1CubeTimestamps mTimestamps;
    private Set<String> mETags = null;
    private volatile long mLastStaleCheckTime = System.currentTimeMillis();
    private final List<String> mCubeLocales;

    public TM1CubeSnapshot(TM1CubeTimestamps timestamps, List<String> cubeLocales) {
        this.mTimestamps = timestamps;
        this.mCubeLocales = cubeLocales;
    }

    public TM1CubeSnapshot create(Set<String> eTags) {
        this.mETags = eTags;
        return this;
    }

    public boolean isSame(Set<String> eTags) {
        if (null == this.mETags) {
            return false;
        }
        return this.mETags.equals(eTags);
    }

    public TM1CubeTimestamps getCubeTimestamps() {
        return this.mTimestamps;
    }

    public Set<String> getSnapshot() {
        return this.mETags;
    }

    public long getLastStaleCheckTime() {
        return this.mLastStaleCheckTime;
    }

    public synchronized void resetLastStaleCheckTime() {
        this.mLastStaleCheckTime = System.currentTimeMillis();
    }

    public boolean needToCheck() {
        return System.currentTimeMillis() - this.mLastStaleCheckTime > 5000L;
    }

    public final List<String> getCubeLocales() {
        if (null == this.mCubeLocales) {
            return Collections.emptyList();
        }
        return this.mCubeLocales;
    }
}

