/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.metadata;

import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonObject;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Attribute;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Cube;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Hierarchy;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1NamedSet;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadata;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadataType;
import com.cognos.xqe.util.LocalizedString;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class TM1Dimension
extends TM1RESTMetadata {
    private long mCardinality;
    private int mOrdinal;
    private String mDefaultHierarchyName;
    private int mNumLevels;
    private boolean mMeasureDimension;
    private boolean mTimeDimension;
    private String mAllLeavesHierarchyName = null;
    private Boolean hasMemberCaptionAttribute;
    private final Map<String, TM1Hierarchy> mHierarchiesByHUN = new LinkedHashMap<String, TM1Hierarchy>();
    private final Map<String, TM1NamedSet> mNamedSetsByNUN = new LinkedHashMap<String, TM1NamedSet>();
    private final Map<String, TM1Attribute> mAttributesByName = new LinkedHashMap<String, TM1Attribute>();

    public TM1Dimension(TM1Cube cube) {
        super(cube);
    }

    public TM1Cube getCube() {
        return (TM1Cube)this.getParent();
    }

    @Override
    public TM1RESTMetadataType getType() {
        return TM1RESTMetadataType.DIMENSION;
    }

    @Override
    public String getUniqueName() {
        if (null == this.mUniqueName) {
            this.mUniqueName = this.mProviderUniqueName;
        }
        return this.mUniqueName;
    }

    public long getCardinality() {
        return this.mCardinality;
    }

    public int getOrdinal() {
        return this.mOrdinal;
    }

    public String getDefaultHierarchyName() {
        return this.mDefaultHierarchyName;
    }

    public int getNumLevels() {
        return this.mNumLevels;
    }

    public boolean isMeasureDimension() {
        return this.mMeasureDimension;
    }

    public boolean isTimeDimension() {
        return this.mTimeDimension;
    }

    public void populate(IJsonObject dimObj, Locale defaultLocale, List<Locale> locales, Map<String, List<IJsonObject>> localizedAttributes) {
        this.mName = dimObj.getStringValue("Name");
        this.mProviderUniqueName = dimObj.getStringValue("UniqueName");
        this.mCaption = this.mName;
        this.mProviderCaption = this.mName;
        this.mAllLeavesHierarchyName = dimObj.getStringValue("AllLeavesHierarchyName");
        this.setLocalizedCaption(dimObj, defaultLocale);
        if (null == this.mLocalizedCaption) {
            this.mLocalizedCaption = new LocalizedString(defaultLocale, this.mCaption);
        }
        this.mMeasureDimension = this.mProviderUniqueName.equals(this.getCube().getMeasureDUN());
        this.mTimeDimension = this.mProviderUniqueName.equals(this.getCube().getTimeDUN());
    }

    public Collection<TM1Hierarchy> getHierarchies() {
        return Collections.unmodifiableCollection(this.mHierarchiesByHUN.values());
    }

    void addHierarchy(TM1Hierarchy hierarchy) {
        this.mHierarchiesByHUN.put(hierarchy.getProviderUniqueName(), hierarchy);
    }

    void addNamedSet(TM1NamedSet namedSet) {
        this.mNamedSetsByNUN.put(namedSet.getProviderUniqueName(), namedSet);
    }

    void setDefaultHierarchy(String defHierarchyHUN) {
        this.mDefaultHierarchyName = defHierarchyHUN;
    }

    public TM1Hierarchy getDefaultHierarchy() {
        for (TM1Hierarchy hierarchy : this.getHierarchies()) {
            if (!hierarchy.getProviderUniqueName().equals(this.mDefaultHierarchyName)) continue;
            return hierarchy;
        }
        return null;
    }

    public Collection<TM1NamedSet> getNamedSets() {
        ArrayList<TM1NamedSet> namedsetsFound = new ArrayList<TM1NamedSet>();
        for (TM1Hierarchy hierarchy : this.getHierarchies()) {
            namedsetsFound.addAll(hierarchy.getNamedSets());
        }
        return Collections.unmodifiableCollection(namedsetsFound);
    }

    public TM1NamedSet getNamedSet(String nun) {
        return this.mNamedSetsByNUN.get(nun);
    }

    void addAttribute(TM1Attribute attribute) {
        this.mAttributesByName.put(attribute.getName().toUpperCase(), attribute);
    }

    public Collection<TM1Attribute> getAttributes() {
        return Collections.unmodifiableCollection(this.mAttributesByName.values());
    }

    public String getAllLeavesHierarchyName() {
        return this.mAllLeavesHierarchyName;
    }

    public TM1Hierarchy findHierarchy(String hun) {
        return this.mHierarchiesByHUN.get(hun);
    }

    public TM1NamedSet findNamedSet(String nun) {
        return this.mNamedSetsByNUN.get(nun);
    }

    public TM1Attribute findAttribute(String name) {
        return this.mAttributesByName.get(name.toUpperCase());
    }

    @Override
    public void dump(PrintWriter writer, int indent) {
        TM1Dimension.printHeader(writer, indent, "TM1Dimension");
        TM1Dimension.printField(writer, indent, "name", this.getName());
        TM1Dimension.printField(writer, indent, "uniqueName", this.getProviderUniqueName());
        TM1Dimension.printField(writer, indent, "caption", this.getCaption());
        TM1Dimension.printField(writer, indent, "ordinal", Integer.toString(this.getOrdinal()));
        TM1Dimension.printField(writer, indent, "cardinality", Long.toString(this.getCardinality()));
        TM1Dimension.printField(writer, indent, "numLevels", Integer.toString(this.getNumLevels()));
        TM1Dimension.printField(writer, indent, "defaultHierarchyName", this.getDefaultHierarchyName());
        for (TM1Attribute attribute : this.getAttributes()) {
            attribute.dump(writer, indent + 2);
        }
        for (TM1Hierarchy hierarchy : this.getHierarchies()) {
            hierarchy.dump(writer, indent + 2);
        }
    }
}

