/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.metadata;

import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonObject;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Attribute;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Dimension;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Level;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadata;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadataLoader;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadataType;
import com.cognos.xqe.data.providers.olap.tm1rest.utils.ITM1Property;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.LongValue;
import com.cognos.xqe.data.values.NullValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.util.LocalizedString;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class TM1Member
extends TM1RESTMetadata {
    private long mOrdinal;
    private long mLevelNumber;
    private long mChildrenCardinality;
    private String mParentMUN;
    private long mParentLevelNumber;
    private String mDescription;
    private String mType;
    private String mDataType;
    private Map<String, Object> mDynamicFields = new HashMap<String, Object>();
    private List<TM1Member> mChildren = new ArrayList<TM1Member>();

    public TM1Member(TM1Level level) {
        super(level);
        this.mLevelNumber = level.getLevelNumber();
    }

    public TM1Dimension getDimension() {
        return this.getLevel().getHierarchy().getDimension();
    }

    @Override
    public TM1RESTMetadataType getType() {
        return TM1RESTMetadataType.MEMBER;
    }

    public final String getDataType() {
        return this.mDataType;
    }

    @Override
    public String getUniqueName() {
        return this.mUniqueName;
    }

    public long getChildrenCardinality() {
        return this.mChildrenCardinality;
    }

    public long getLevelNumber() {
        return this.mLevelNumber;
    }

    public long getOrdinal() {
        return this.mOrdinal;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getParentMUN() {
        return this.mParentMUN;
    }

    public long getParentLevelNumber() {
        return this.mParentLevelNumber;
    }

    public TM1Level getLevel() {
        return (TM1Level)this.getParent();
    }

    public String getMemberType() {
        return this.mType;
    }

    public void populate(IJsonObject memberObj, String[] dimProperties, Locale defaultLocale) {
        IJsonObject jsonElement;
        Long childrenCardinality;
        this.mName = memberObj.getStringValue("Name");
        IJsonObject jsonAttributes = memberObj.getJsonObject("Attributes");
        if (null == jsonAttributes) {
            this.mCaption = this.mName;
        } else {
            this.mCaption = jsonAttributes.getStringValue("Caption");
            if (this.mCaption == null || this.mCaption.isEmpty()) {
                this.mCaption = this.mName;
            }
            this.mDescription = jsonAttributes.getStringValue("DESCRIPTION");
        }
        if (this.mDescription == null || this.mDescription.isEmpty()) {
            this.mDescription = this.mName;
        }
        this.mProviderCaption = this.mCaption;
        this.mUniqueName = this.mProviderUniqueName = memberObj.getStringValue("UniqueName");
        this.mType = memberObj.getStringValue("Type");
        this.mOrdinal = memberObj.getLongValue("Ordinal");
        this.mParentLevelNumber = this.mLevelNumber - 1L;
        IJsonObject jsonParent = memberObj.getJsonObject("Parent");
        if (jsonParent != null) {
            this.mParentMUN = jsonParent.getStringValue("UniqueName");
        }
        this.mChildrenCardinality = (childrenCardinality = memberObj.getLongValue("Children@odata.count")) != null ? childrenCardinality : 0L;
        this.setLocalizedCaption(memberObj, defaultLocale);
        if (null == this.mLocalizedCaption) {
            this.mLocalizedCaption = new LocalizedString(defaultLocale, this.mCaption);
        }
        if (dimProperties != null) {
            for (String dimProperty : dimProperties) {
                if (TM1RESTMetadataLoader.isDefaultProperty(dimProperty)) {
                    this.mDynamicFields.put(dimProperty, this.getDefaultPropertyValue(dimProperty));
                    continue;
                }
                TM1Attribute attribute = this.getDimension().findAttribute(dimProperty);
                if (attribute == null || jsonAttributes == null) continue;
                this.mDynamicFields.put(dimProperty, this.getAttributeValue(attribute, jsonAttributes));
            }
        }
        if (null != (jsonElement = memberObj.getJsonObject("Element"))) {
            this.mDataType = jsonElement.getStringValue("Type");
        }
    }

    private Value getDefaultPropertyValue(String dimProperty) {
        NullValue value;
        TM1MemberProperty property = TM1MemberProperty.valueOf(dimProperty);
        switch (property) {
            case PARENT_UNIQUE_NAME: {
                StringValue svalue = DataValueFactory.createStringValue();
                svalue.set(this.mParentMUN);
                if (null == this.mParentMUN) {
                    svalue.setState(ValueState.NULL);
                }
                value = svalue;
                break;
            }
            case PARENT_LEVEL: {
                LongValue lvalue = DataValueFactory.createLongValue();
                lvalue.set(this.mLevelNumber);
                value = lvalue;
                break;
            }
            default: {
                value = DataValueFactory.createNullValue();
                value.setState(ValueState.NULL);
            }
        }
        return value;
    }

    private Object getAttributeValue(TM1Attribute attribute, IJsonObject jsonAttributes) {
        Object ovalue;
        Object value = null;
        if (attribute.getDataType() == DataTypeFactory.getStringType()) {
            value = jsonAttributes.getStringValue(attribute.getName());
        } else if (attribute.getDataType() == DataTypeFactory.getNumericType() && (ovalue = jsonAttributes.getObject(attribute.getName())) != null) {
            if (ovalue instanceof Long) {
                LongValue longValue = DataValueFactory.createLongValue();
                longValue.set(ovalue);
                value = longValue;
            } else if (ovalue instanceof Double) {
                DoubleValue doubleValue = DataValueFactory.createDoubleValue();
                doubleValue.set(ovalue);
                value = doubleValue;
            } else {
                value = ovalue;
            }
        }
        if (null == value) {
            if (attribute.getDataType() == DataTypeFactory.getNumericType()) {
                value = DataValueFactory.createLongValue();
                ((LongValue)value).set(0);
                ((LongValue)value).setState(ValueState.NULL);
            } else {
                value = DataValueFactory.createNullValue();
                ((NullValue)value).setState(ValueState.NULL);
            }
        }
        return value;
    }

    public Map<String, Object> getDynamicFields() {
        return this.mDynamicFields;
    }

    public void addChild(TM1Member member) {
        this.mChildren.add(member);
    }

    public List<TM1Member> getChildren() {
        return this.mChildren;
    }

    @Override
    public void dump(PrintWriter writer, int indent) {
        TM1Member.printHeader(writer, indent, "TM1Member");
        TM1Member.printField(writer, indent, "name", this.getName());
        TM1Member.printField(writer, indent, "uniqueName", this.getName());
        TM1Member.printField(writer, indent, "caption", this.getCaption());
        TM1Member.printField(writer, indent, "description", this.getDescription());
        TM1Member.printField(writer, indent, "ordinal", Long.toString(this.getOrdinal()));
        TM1Member.printField(writer, indent, "parentMUN", this.getParentMUN());
        TM1Member.printField(writer, indent, "levelNumber", Long.toString(this.getLevelNumber()));
        TM1Member.printField(writer, indent, "parentLevelNumber", Long.toString(this.getParentLevelNumber()));
        TM1Member.printField(writer, indent, "childrenCardinality", Long.toString(this.getChildrenCardinality()));
    }

    public static enum TM1MemberProperty implements ITM1Property
    {
        PARENT_UNIQUE_NAME((IDataType)DataTypeFactory.getStringType()),
        PARENT_LEVEL((IDataType)DataTypeFactory.getNumericType());

        private final String mPropertyName;
        private final IDataType mDataType;

        private TM1MemberProperty() {
            this.mPropertyName = this.name();
            this.mDataType = DataTypeFactory.getAnyType();
        }

        private TM1MemberProperty(String propertyName, IDataType dataType) {
            this.mPropertyName = propertyName;
            this.mDataType = dataType;
        }

        private TM1MemberProperty(IDataType dataType) {
            this.mPropertyName = this.name();
            this.mDataType = dataType;
        }

        @Override
        public String getPropertyName() {
            return this.mPropertyName;
        }

        @Override
        public IDataType getDataType() {
            return this.mDataType;
        }
    }
}

