/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.metadata;

import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTConnection;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTMessageKeys;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTODPException;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.DataSourceProjectLocales;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonObject;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1CubeTimestamps;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadataLoader;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.query.CubeDefaultMeasureQuery;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.query.CubeRecordQuery;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.query.DimensionRecordQuery;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.query.HierarchyRecordQuery;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.query.HierarchyRootMembersQuery;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.query.LevelRecordQuery;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.query.MeasureRecordQuery;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.query.MemberRecordQuery;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.query.MetadataQuery;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.query.NamedSetLevelUniqueNamesRecordQuery;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.query.NamedSetMemberRecordQuery;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.query.NamedSetRecordQuery;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.query.PropertyRecordQuery;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.ODataUriBuilder;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClient;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClientResponse;
import com.cognos.xqe.data.providers.olap.tm1rest.utils.TM1Utils;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.TreeOperatorEnum;
import com.cognos.xqe.metadata.record.CatalogRecord;
import com.cognos.xqe.metadata.record.CubeRecord;
import com.cognos.xqe.metadata.record.DimensionRecord;
import com.cognos.xqe.metadata.record.HierarchyNamedSetRecord;
import com.cognos.xqe.metadata.record.HierarchyRecord;
import com.cognos.xqe.metadata.record.LevelRecord;
import com.cognos.xqe.metadata.record.MeasureRecord;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.metadata.record.PropertyRecord;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.transformation.ma.provider.MASearchCriteria;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocalizedString;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;

public class TM1RESTMetadataSession {
    private final TM1RESTConnection mConnection;
    private final TM1RESTMetadataLoader mLoader;
    private final Locale mLocale;
    private final ExecutionEnvironment mExecEnv;

    public TM1RESTMetadataSession(TM1RESTConnection connection, Locale locale, ExecutionEnvironment execEnv) {
        this.mConnection = connection;
        this.mLoader = new TM1RESTMetadataLoader(this, locale, execEnv);
        this.mLocale = locale;
        this.mExecEnv = execEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CubeRecord> getCubeRecords(IRestrictions restrictions) {
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        Boolean refresh = (Boolean)restrictions.getValueOf(RestrictionType.REFRESH, (Object)Boolean.FALSE);
        CubeRecordQuery query = new CubeRecordQuery(this);
        query.setLocale(this.mLocale);
        query.setCubeName(cubeName);
        query.setRefresh(refresh);
        this.setRangeRestrictions(query, restrictions);
        this.setCubeLocalesRestriction(query, restrictions);
        try {
            List<CubeRecord> list = query.execute();
            return list;
        }
        finally {
            query.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DimensionRecord> getDimensionRecords(IRestrictions restrictions) {
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String dun = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        DimensionRecordQuery query = new DimensionRecordQuery(this);
        query.setLocale(this.mLocale);
        query.setCubeName(cubeName);
        query.setDUN(dun);
        this.setRangeRestrictions(query, restrictions);
        this.setCubeLocalesRestriction(query, restrictions);
        try {
            List<DimensionRecord> list = query.execute();
            return list;
        }
        finally {
            query.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HierarchyRecord> getHierarchyRecords(IRestrictions restrictions) {
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String dun = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String hun = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        HierarchyRecordQuery query = new HierarchyRecordQuery(this);
        query.setLocale(this.mLocale);
        query.setCubeName(cubeName);
        query.setDUN(dun);
        query.setHUN(hun);
        this.setRangeRestrictions(query, restrictions);
        this.setCubeLocalesRestriction(query, restrictions);
        try {
            List<HierarchyRecord> list = query.execute();
            return list;
        }
        finally {
            query.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MemberRecord> getHierarchyRootMemberRecords(IRestrictions restrictions) {
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String hun = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        HierarchyRootMembersQuery query = new HierarchyRootMembersQuery(this);
        query.setLocale(this.mLocale);
        query.setCubeName(cubeName);
        query.setHUN(hun);
        this.setRangeRestrictions(query, restrictions);
        this.setCubeLocalesRestriction(query, restrictions);
        try {
            List<MemberRecord> list = query.execute();
            return list;
        }
        finally {
            query.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LevelRecord> getLevelRecords(IRestrictions restrictions) {
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String dun = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String hun = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        String lun = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME);
        Integer levelNumber = (Integer)restrictions.getValueOf(RestrictionType.LEVEL_NUMBER);
        LevelRecordQuery query = new LevelRecordQuery(this);
        query.setLocale(this.mLocale);
        query.setCubeName(cubeName);
        query.setDUN(dun);
        query.setHUN(hun);
        query.setLUN(lun);
        query.setLevelNumber(levelNumber);
        this.setRangeRestrictions(query, restrictions);
        this.setCubeLocalesRestriction(query, restrictions);
        try {
            List<LevelRecord> list = query.execute();
            return list;
        }
        finally {
            query.release();
        }
    }

    public TM1RESTConnection getConnection() {
        return this.mConnection;
    }

    public TM1RESTMetadataLoader getLoader() {
        return this.mLoader;
    }

    public TM1RESTMetadataLoader getLoader(List<String> locales) {
        this.mLoader.setLocalesRestriction(locales);
        return this.mLoader;
    }

    public List<CatalogRecord> getCatalogRecords(IRestrictions restrictions) {
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        if (null == catalogName || "CATALOG".equals(catalogName)) {
            CatalogRecord record = new CatalogRecord();
            record.setUniqueName("CATALOG");
            record.setName("CATALOG");
            record.setCaption((ILocalizedString)new LocalizedString(this.mLocale, "CATALOG"));
            record.setDescription("");
            return Collections.singletonList(record);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCubeDefaultMeasure(IRestrictions restrictions) {
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        CubeDefaultMeasureQuery query = new CubeDefaultMeasureQuery(this);
        query.setLocale(this.mLocale);
        query.setCubeName(cubeName);
        this.setCubeLocalesRestriction(query, restrictions);
        try {
            List<String> result = query.execute();
            if (result.isEmpty()) {
                throw new TM1RESTODPException(TM1RESTMessageKeys.MET_NO_DEFAULT_MEASURE, cubeName);
            }
            String string = result.get(0);
            return string;
        }
        finally {
            query.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MeasureRecord> getMeasureRecords(IRestrictions restrictions) {
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String mun = (String)restrictions.getValueOf(RestrictionType.MEASURE_UNIQUE_NAME);
        Integer levelNumber = (Integer)restrictions.getValueOf(RestrictionType.LEVEL_NUMBER);
        EnumSet treeOps = (EnumSet)restrictions.getValueOf(RestrictionType.TREEOP);
        boolean rootsOnly = false;
        if (null != levelNumber) {
            if (levelNumber == 0) {
                rootsOnly = true;
            } else {
                throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionIllegalValue, "LEVEL_NUMBER", levelNumber.toString());
            }
        }
        boolean includeSelf = false;
        boolean includeChildren = false;
        if (null != treeOps) {
            block7: for (TreeOperatorEnum op : treeOps) {
                switch (op) {
                    case SELF: {
                        includeSelf = true;
                        continue block7;
                    }
                    case CHILDREN: {
                        includeChildren = true;
                        continue block7;
                    }
                }
                throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionIllegalValue, "TREEOP", treeOps.toString());
            }
        } else {
            includeSelf = true;
        }
        MeasureRecordQuery query = new MeasureRecordQuery(this);
        query.setLocale(this.mLocale);
        query.setCubeName(cubeName);
        query.setMUN(mun);
        query.setRootsOnly(rootsOnly);
        query.setIncludeSelf(includeSelf);
        query.setIncludeChildren(includeChildren);
        this.setRangeRestrictions(query, restrictions);
        this.setCubeLocalesRestriction(query, restrictions);
        try {
            List<MeasureRecord> list = query.execute();
            return list;
        }
        finally {
            query.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MemberRecord> getMemberRecords(IRestrictions restrictions) {
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String dun = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String hun = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        String lun = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME);
        Integer levelNumber = (Integer)restrictions.getValueOf(RestrictionType.LEVEL_NUMBER);
        Integer depth = (Integer)restrictions.getValueOf(RestrictionType.SCOPE);
        String mun = (String)restrictions.getValueOf(RestrictionType.MEMBER_UNIQUE_NAME);
        MASearchCriteria searchCriteria = (MASearchCriteria)restrictions.getValueOf(RestrictionType.MEMBERSEARCH);
        EnumSet treeOps = (EnumSet)restrictions.getValueOf(RestrictionType.TREEOP);
        boolean dataQuery = (Boolean)restrictions.getValueOf(RestrictionType.DATA_QUERY, (Object)false);
        boolean munValidationQuery = (Boolean)restrictions.getValueOf(RestrictionType.MUN_VALIDATION_QUERY, (Object)false);
        MemberRecordQuery query = new MemberRecordQuery(this);
        query.setDataQuery(dataQuery);
        query.setMunValidationQuery(munValidationQuery);
        query.setLocale(this.mLocale);
        query.setCubeName(cubeName);
        query.setDUN(dun);
        query.setHUN(hun);
        query.setLUN(lun);
        if (levelNumber != null) {
            query.setLevelNumber(levelNumber);
        }
        if (depth != null && searchCriteria != null) {
            searchCriteria.setDepth(depth.intValue());
        }
        query.setMUN(mun);
        query.setTreeOps(treeOps);
        query.setSearchCriteria(searchCriteria);
        query.setDynamicProperties((String)restrictions.getValueOf(RestrictionType.DIMENSION_PROPERTIES));
        this.setRangeRestrictions(query, restrictions);
        this.setCubeLocalesRestriction(query, restrictions);
        try {
            List<MemberRecord> list = query.execute();
            return list;
        }
        finally {
            query.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HierarchyNamedSetRecord> getHierarchyNamedSetRecords(IRestrictions restrictions) {
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String dun = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String hun = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        String nsun = (String)restrictions.getValueOf(RestrictionType.SET);
        NamedSetRecordQuery query = new NamedSetRecordQuery(this);
        query.setLocale(this.mLocale);
        query.setCubeName(cubeName);
        query.setDUN(dun);
        query.setHUN(hun);
        query.setNSUN(nsun);
        this.setRangeRestrictions(query, restrictions);
        this.setCubeLocalesRestriction(query, restrictions);
        try {
            List<HierarchyNamedSetRecord> list = query.execute();
            return list;
        }
        finally {
            query.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MemberRecord> getNamedSetMemberRecords(IRestrictions restrictions) {
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String dun = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String hun = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        String nsun = (String)restrictions.getValueOf(RestrictionType.SET);
        EnumSet treeOpSet = (EnumSet)restrictions.getValueOf(RestrictionType.TREEOP, null);
        boolean ascendants = false;
        if (treeOpSet != null) {
            ascendants = treeOpSet.contains(TreeOperatorEnum.ANCESTORS);
        }
        NamedSetMemberRecordQuery query = new NamedSetMemberRecordQuery(this);
        query.setLocale(this.mLocale);
        query.setCubeName(cubeName);
        query.setDUN(dun);
        query.setHUN(hun);
        query.setNSUN(nsun);
        query.setAscendants(ascendants);
        this.setRangeRestrictions(query, restrictions);
        this.setCubeLocalesRestriction(query, restrictions);
        try {
            List<MemberRecord> list = query.execute();
            return list;
        }
        finally {
            query.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getNamedSetLevelUniqueNames(IRestrictions restrictions) {
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String dun = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String hun = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        String nsun = (String)restrictions.getValueOf(RestrictionType.SET);
        NamedSetLevelUniqueNamesRecordQuery query = new NamedSetLevelUniqueNamesRecordQuery(this);
        query.setLocale(this.mLocale);
        query.setCubeName(cubeName);
        query.setDUN(dun);
        query.setHUN(hun);
        query.setNSUN(nsun);
        this.setRangeRestrictions(query, restrictions);
        this.setCubeLocalesRestriction(query, restrictions);
        try {
            List<String> list = query.execute();
            return list;
        }
        finally {
            query.release();
        }
    }

    private void setRangeRestrictions(MetadataQuery<?> query, IRestrictions restrictions) {
        Integer rangeFrom = (Integer)restrictions.getValueOf(RestrictionType.FROM);
        Integer rangeSize = (Integer)restrictions.getValueOf(RestrictionType.SIZE);
        if (null != rangeFrom) {
            query.setRangeFrom(rangeFrom);
        }
        if (null != rangeSize) {
            EnumSet treeOpSet = (EnumSet)restrictions.getValueOf(RestrictionType.TREEOP, null);
            if (treeOpSet != null && treeOpSet.contains(TreeOperatorEnum.SELF) && treeOpSet.size() > 1 && rangeSize != Integer.MAX_VALUE) {
                Integer n = rangeSize;
                Integer n2 = rangeSize = Integer.valueOf(rangeSize + 1);
            }
            query.setRangeSize(rangeSize);
        }
    }

    private void setCubeLocalesRestriction(MetadataQuery<?> query, IRestrictions restrictions) {
        List locales = (List)restrictions.getValueOf(RestrictionType.PROJECT_LOCALES);
        if (null == locales || locales.isEmpty()) {
            List dsProjectLocales = (List)this.getConnection().getConnectionParameters().valueOf(DataSourceProjectLocales.class);
            if (dsProjectLocales != null && !dsProjectLocales.isEmpty()) {
                query.setCubeLocales(dsProjectLocales);
            } else {
                query.setCubeLocales(Collections.singletonList(this.mLocale.toLanguageTag()));
            }
            return;
        }
        query.setCubeLocales(locales);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PropertyRecord> getPropertyRecords(IRestrictions restrictions) {
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String dun = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String hun = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        String lun = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME);
        String property = (String)restrictions.getValueOf(RestrictionType.PROPERTY);
        String nun = (String)restrictions.getValueOf(RestrictionType.SET);
        PropertyRecordQuery query = new PropertyRecordQuery(this);
        query.setLocale(this.mLocale);
        query.setCubeName(cubeName);
        query.setDUN(dun);
        query.setHUN(hun);
        query.setLUN(lun);
        query.setPUN(property);
        query.setNUN(nun);
        this.setRangeRestrictions(query, restrictions);
        this.setCubeLocalesRestriction(query, restrictions);
        try {
            List<PropertyRecord> list = query.execute();
            return list;
        }
        finally {
            query.release();
        }
    }

    public TM1CubeTimestamps getCubeTimestamps(String cubeName) {
        RESTClient client = this.getConnection().getServer();
        ODataUriBuilder cubeUri = client.getUriBuilder();
        cubeUri.entityId("Cubes", cubeName);
        try {
            IJsonObject jsonCube = client.getJsonResource(cubeUri.toString(), this.mExecEnv, this.mLocale);
            RESTClientResponse.validateAndThrow(jsonCube, cubeName, TM1RESTMessageKeys.ERR_UNKNOWN_TM1_ERROR_WITH_CODE_AND_MESSAGE);
            String lastSchemaUpdate = jsonCube.getStringValue("LastSchemaUpdate");
            String lastDataUpdate = jsonCube.getStringValue("LastDataUpdate");
            return new TM1CubeTimestamps(TM1Utils.getDateValue(lastSchemaUpdate), TM1Utils.getDateValue(lastDataUpdate));
        }
        catch (TM1RESTODPException ex) {
            throw new TM1RESTODPException(TM1RESTMessageKeys.MET_CANNOT_FIND_CUBE, cubeName);
        }
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.mExecEnv;
    }
}

