/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.metadata.query;

import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTMessageKeys;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTODPException;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Cube;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Dimension;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Hierarchy;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Member;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadataSession;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.query.MetadataQuery;
import java.util.Collections;
import java.util.List;

public class CubeDefaultMeasureQuery
extends MetadataQuery<String> {
    private String mCubeName;

    public CubeDefaultMeasureQuery(TM1RESTMetadataSession session) {
        super(session);
    }

    public void setCubeName(String cubeName) {
        this.mCubeName = cubeName;
    }

    @Override
    public List<String> execute() {
        List<TM1Member> roots;
        TM1Cube cube = this.getLoader(this.getCubeLocales()).loadCube(this.mCubeName, this.getCubeCache());
        if (null == cube) {
            throw new TM1RESTODPException(TM1RESTMessageKeys.MET_CANNOT_FIND_CUBE, this.mCubeName);
        }
        TM1Dimension measureDimension = cube.getMeasureDimension();
        if (null == measureDimension) {
            throw new TM1RESTODPException(TM1RESTMessageKeys.MET_NO_MEASURE_DIMENSION, this.mCubeName);
        }
        TM1Hierarchy measureHier = measureDimension.getDefaultHierarchy();
        if (null == measureHier) {
            throw new TM1RESTODPException(TM1RESTMessageKeys.MET_NONEXISTANT_HIERARCHY, measureDimension.getDefaultHierarchyName());
        }
        String measureUN = measureHier.getDefaultMemberUN();
        if (!(null != measureUN && measureUN.length() != 0 || (roots = measureHier.getAccessibleRoots()).isEmpty())) {
            measureUN = roots.get(0).getProviderUniqueName();
        }
        return Collections.singletonList(measureUN);
    }
}

