/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.metadata.query;

import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTMessageKeys;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTODPException;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Cube;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Dimension;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Hierarchy;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Level;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Member;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadataSession;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.query.MetadataQuery;
import com.cognos.xqe.data.providers.olap.tm1rest.utils.TreeOperator;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.record.MeasureRecord;
import com.cognos.xqe.util.ILocalizedString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

public class MeasureRecordQuery
extends MetadataQuery<MeasureRecord> {
    private static final String STRING = "String";
    private static final String NUMERIC = "Numeric";
    private String mCubeName = null;
    private String mMUN = null;
    private boolean mRootsOnly = false;
    private boolean mIncludeSelf = true;
    private boolean mIncludeChildren = false;

    public MeasureRecordQuery(TM1RESTMetadataSession session) {
        super(session);
    }

    public void setCubeName(String cubeName) {
        this.mCubeName = cubeName;
    }

    public void setMUN(String mun) {
        this.mMUN = mun;
    }

    public void setRootsOnly(boolean isRootsOnly) {
        this.mRootsOnly = isRootsOnly;
    }

    public void setIncludeSelf(boolean includeSelf) {
        this.mIncludeSelf = includeSelf;
    }

    public void setIncludeChildren(boolean includeChildren) {
        this.mIncludeChildren = includeChildren;
    }

    @Override
    public List<MeasureRecord> execute() {
        this.checkRangeRestrictions();
        if (null == this.mCubeName) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "A cube name was not specified.");
        }
        if (this.mRangeSize < 1) {
            return Collections.emptyList();
        }
        TM1Cube cube = this.getLoader(this.getCubeLocales()).loadCube(this.mCubeName, this.getCubeCache());
        if (null == cube) {
            throw new TM1RESTODPException(TM1RESTMessageKeys.MET_CANNOT_FIND_CUBE, this.mCubeName);
        }
        TM1Dimension measureDim = cube.getMeasureDimension();
        if (null == measureDim) {
            throw new TM1RESTODPException(TM1RESTMessageKeys.MET_NO_MEASURE_DIMENSION, this.mCubeName);
        }
        ArrayList<TM1Member> measuresFound = new ArrayList<TM1Member>();
        this.findMeasures(measureDim, measuresFound);
        int effectiveSize = Math.min(this.mRangeSize, measuresFound.size() - this.mRangeFrom);
        if (effectiveSize <= 0) {
            return Collections.emptyList();
        }
        ArrayList<MeasureRecord> records = new ArrayList<MeasureRecord>(effectiveSize);
        for (int i = this.mRangeFrom; i < this.mRangeFrom + effectiveSize; ++i) {
            records.add(this.buildRecord((TM1Member)measuresFound.get(i)));
        }
        return records;
    }

    private void findMeasures(TM1Dimension dimension, List<TM1Member> result) {
        TM1Hierarchy hierarchy = dimension.getDefaultHierarchy();
        if (null == hierarchy) {
            throw new TM1RESTODPException(TM1RESTMessageKeys.MET_NONEXISTANT_HIERARCHY, dimension.getProviderUniqueName());
        }
        EnumSet<TreeOperator> treeOps = EnumSet.noneOf(TreeOperator.class);
        if (null != this.mMUN) {
            TM1Member member = hierarchy.getMemberWithChildren(this.mMUN);
            if (this.mIncludeSelf) {
                if (member != null) {
                    result.add(member);
                } else {
                    for (TM1Member amember : hierarchy.getAccessibleRoots()) {
                        if (!this.mMUN.equals(amember.getUniqueName())) continue;
                        result.add(amember);
                        break;
                    }
                }
            }
            if (null == member) {
                return;
            }
            if (this.mIncludeChildren) {
                result.addAll(member.getChildren());
            }
        } else if (this.mRootsOnly) {
            result.addAll(hierarchy.getAccessibleRoots());
        } else {
            for (TM1Member rootMember : hierarchy.getAccessibleRoots()) {
                result.add(rootMember);
                if (rootMember.getChildren().isEmpty()) continue;
                this.addChildren(rootMember, result);
            }
        }
    }

    private MeasureRecord buildRecord(TM1Member measure) {
        TM1Level level = measure.getLevel();
        TM1Hierarchy hierarchy = level.getHierarchy();
        TM1Dimension dimension = hierarchy.getDimension();
        TM1Cube cube = dimension.getCube();
        MeasureRecord record = new MeasureRecord();
        record.setCatalogName("CATALOG");
        record.setCubeName(cube.getName());
        record.setDimensionUniqueName(dimension.getProviderUniqueName());
        record.setHierarchyUniqueName(hierarchy.getProviderUniqueName());
        record.setLevelUniqueName(level.getProviderUniqueName());
        if (NUMERIC.equals(measure.getDataType())) {
            record.setDataType((IDataType)DataTypeFactory.getDoubleType());
        } else if (STRING.equals(measure.getDataType())) {
            record.setDataType((IDataType)DataTypeFactory.getStringType());
        } else {
            record.setDataType((IDataType)DataTypeFactory.getDoubleType());
        }
        record.setRegularAggregate(AggregateTypeEnum.UNKNOWN);
        record.setName(measure.getName());
        record.setUniqueName(measure.getProviderUniqueName());
        record.setDescription(measure.getDescription());
        record.setUniqueId(measure.getName());
        record.setDynamicField("PPDS_KEY", (Object)measure.getName());
        record.setCaption((ILocalizedString)measure.getLocalizedCaption());
        return record;
    }

    private void addChildren(TM1Member member, List<TM1Member> result) {
        for (TM1Member child : member.getChildren()) {
            result.add(child);
            this.addChildren(child, result);
        }
    }

    @Override
    public void release() {
    }
}

