/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.metadata.query;

import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTMessageKeys;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTODPException;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Cube;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Dimension;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Hierarchy;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Level;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Member;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadata;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadataSession;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.query.MetadataQuery;
import com.cognos.xqe.data.providers.olap.tm1rest.utils.QueryMode;
import com.cognos.xqe.data.providers.olap.tm1rest.utils.TM1Utils;
import com.cognos.xqe.data.providers.olap.tm1rest.utils.TreeOperator;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.RollupTypeEnum;
import com.cognos.xqe.metadata.TreeOperatorEnum;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.runtree.ma.MAMunValidationException;
import com.cognos.xqe.transformation.ma.provider.MASearchCriteria;
import com.cognos.xqe.util.ILocalizedString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MemberRecordQuery
extends MetadataQuery<MemberRecord> {
    private static final String BRACE = "[";
    private static final int RANGE = 51;
    private String mCubeName = null;
    private String mDUN = null;
    private String mHUN = null;
    private String mLUN = null;
    private Integer mLevelNumber = null;
    private String mMUN = null;
    private Map<String, String> mPropNameToUniqueName = null;
    private String[] dimProperties;
    private MASearchCriteria mSearchCriteria = null;
    private EnumSet<TreeOperatorEnum> mTreeOps = null;
    private boolean mDataQuery = false;
    private boolean mMunValidationQuery = false;

    public MemberRecordQuery(TM1RESTMetadataSession session) {
        super(session);
    }

    public void setCubeName(String cubeName) {
        this.mCubeName = cubeName;
    }

    public void setDUN(String dun) {
        this.mDUN = dun;
    }

    public void setHUN(String hun) {
        this.mHUN = hun;
    }

    public void setLUN(String lun) {
        this.mLUN = lun;
    }

    public void setLevelNumber(Integer levelNumber) {
        this.mLevelNumber = levelNumber;
    }

    public void setMUN(String mun) {
        this.mMUN = mun;
    }

    public void setSearchCriteria(MASearchCriteria searchCriteria) {
        this.mSearchCriteria = searchCriteria;
    }

    public void setTreeOps(EnumSet<TreeOperatorEnum> treeOps) {
        this.mTreeOps = treeOps;
    }

    public void setDynamicProperties(String propString) {
        if (this.mPropNameToUniqueName == null) {
            this.mPropNameToUniqueName = new HashMap<String, String>();
        }
        if (propString == null) {
            this.dimProperties = new String[0];
        } else {
            this.dimProperties = propString.split(",");
            for (int i = 0; i < this.dimProperties.length; ++i) {
                String prop = this.dimProperties[i].trim();
                String propName = prop.startsWith(BRACE) ? prop.substring(prop.lastIndexOf(BRACE) + 1, prop.length() - 1) : prop;
                this.mPropNameToUniqueName.put(propName, prop);
            }
            String[] temp = new String[]{};
            this.dimProperties = this.mPropNameToUniqueName.keySet().toArray(temp);
        }
    }

    public void setDataQuery(boolean dataQuery) {
        this.mDataQuery = dataQuery;
    }

    public void setMunValidationQuery(boolean munValidationQuery) {
        this.mMunValidationQuery = munValidationQuery;
    }

    @Override
    public List<MemberRecord> execute() {
        this.checkRangeRestrictions();
        if (null == this.mCubeName) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "A cube name was not specified.");
        }
        if (this.mRangeSize < 1) {
            return Collections.emptyList();
        }
        TM1Cube cube = this.getLoader(this.getCubeLocales()).loadCube(this.mCubeName, this.getCubeCache());
        if (null == cube) {
            throw new TM1RESTODPException(TM1RESTMessageKeys.MET_CANNOT_FIND_CUBE, this.mCubeName);
        }
        EnumSet<TreeOperator> tm1TreeOps = null != this.mTreeOps ? MemberRecordQuery.convertTreeOps(this.mTreeOps) : EnumSet.noneOf(TreeOperator.class);
        EnumSet<QueryMode> queryModes = EnumSet.noneOf(QueryMode.class);
        if (this.mDataQuery) {
            queryModes.add(QueryMode.DataQuery);
        }
        if (this.mMunValidationQuery) {
            queryModes.add(QueryMode.MunValidationQuery);
        }
        ArrayList<TM1Member> membersFound = new ArrayList<TM1Member>();
        if (null != this.mSearchCriteria) {
            this.memberSearch(cube, tm1TreeOps, queryModes, membersFound);
        } else if (null != this.mMUN) {
            this.findMembersWithTreeOps(cube, tm1TreeOps, queryModes, membersFound);
        } else {
            this.findMembers(cube, membersFound);
        }
        if (membersFound.isEmpty()) {
            return Collections.emptyList();
        }
        int effectiveSize = Math.min(this.mRangeSize, membersFound.size());
        ArrayList<MemberRecord> records = new ArrayList<MemberRecord>(effectiveSize);
        for (int i = 0; i < effectiveSize; ++i) {
            records.add(MemberRecordQuery.buildRecord((TM1Member)membersFound.get(i), this.mPropNameToUniqueName));
        }
        return records;
    }

    private void findMembers(TM1Cube cube, List<TM1Member> result) {
        if (null != this.mLUN) {
            TM1Level level = TM1Utils.findLevel(cube, this.mLUN, true);
            TM1Hierarchy hierarchy = level.getHierarchy();
            if (level.getLevelNumber() == 0L && hierarchy.isParentChild()) {
                result.addAll(hierarchy.getAccessibleRoots());
                return;
            }
            this.getLoader(this.getCubeLocales()).loadLevelMembers(level, this.dimProperties, this.mRangeFrom, this.mRangeSize, this.mDataQuery, result);
        } else if (null != this.mHUN) {
            TM1Hierarchy hierarchy = TM1Utils.findHierarchy(cube, this.mHUN, true);
            this.findMembers(hierarchy, result);
        } else if (null != this.mDUN) {
            TM1Dimension dimension = TM1Utils.findDimension(cube, this.mDUN, true);
            for (TM1Hierarchy hierarchy : dimension.getHierarchies()) {
                this.findMembers(hierarchy, result);
                if (result.size() < this.mRangeSize) continue;
                break;
            }
        } else {
            block1: for (TM1Dimension dimension : cube.getDimensions()) {
                for (TM1Hierarchy hierarchy : dimension.getHierarchies()) {
                    this.findMembers(hierarchy, result);
                    if (result.size() < this.mRangeSize) continue;
                    continue block1;
                }
            }
        }
    }

    private void findMembersWithTreeOps(TM1Cube cube, Set<TreeOperator> treeOps, Set<QueryMode> queryModes, List<TM1Member> result) throws TM1RESTODPException {
        if (null == treeOps) {
            throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionMissing, RestrictionType.TREEOP.toString());
        }
        String memberName = TM1Utils.convertV5MUNToProviderMUN(this.mMUN);
        String providerDUN = TM1Utils.extractProviderDUNFromV5MUN(this.mMUN);
        String providerHUN = TM1Utils.extractProviderHUNFromV5MUN(this.mMUN);
        TM1Dimension dimension = cube.findDimension(providerDUN);
        if (null == dimension) {
            if (queryModes.contains((Object)QueryMode.MunValidationQuery)) {
                ArrayList emptyContext = new ArrayList();
                XQEMessage message = new XQEMessage(TM1RESTMessageKeys.MET_NONEXISTANT_DIMENSION, providerDUN, emptyContext);
                String errMessage = message.getBody(this.mLocale);
                throw new MAMunValidationException(MAMunValidationException.Status.InvalidDimension, errMessage);
            }
            throw new TM1RESTODPException(TM1RESTMessageKeys.MET_NONEXISTANT_DIMENSION, providerDUN);
        }
        TM1Hierarchy hierarchy = dimension.findHierarchy(providerHUN);
        if (null == hierarchy) {
            if (queryModes.contains((Object)QueryMode.MunValidationQuery)) {
                ArrayList emptyContext = new ArrayList();
                XQEMessage message = new XQEMessage(TM1RESTMessageKeys.MET_NONEXISTANT_HIERARCHY, providerHUN, emptyContext);
                String errMessage = message.getBody(this.mLocale);
                throw new MAMunValidationException(MAMunValidationException.Status.InvalidHierarchy, errMessage);
            }
            throw new TM1RESTODPException(TM1RESTMessageKeys.MET_NONEXISTANT_HIERARCHY, providerHUN);
        }
        if (treeOps.isEmpty() || treeOps.size() == 1 && treeOps.contains((Object)TreeOperator.Self) && !queryModes.contains((Object)QueryMode.DataQuery)) {
            for (TM1Member root : hierarchy.getAccessibleRoots()) {
                if (!root.getName().equals(memberName)) continue;
                result.add(root);
                return;
            }
        }
        if (treeOps.contains((Object)TreeOperator.Siblings)) {
            List<TM1Member> accessibleRoots = hierarchy.getAccessibleRoots();
            for (TM1Member root : accessibleRoots) {
                if (!root.getName().equals(memberName)) continue;
                if (this.dimProperties != null && this.dimProperties.length > 0) {
                    accessibleRoots = this.getLoader(this.getCubeLocales()).loadAccessibleRootMembers(hierarchy);
                }
                result.addAll(accessibleRoots);
                if (!treeOps.contains((Object)TreeOperator.Self)) {
                    result.remove(root);
                }
                return;
            }
        }
        this.getLoader(this.getCubeLocales()).loadMembersTreeOp(hierarchy, memberName, treeOps, queryModes, this.dimProperties, 0, 51, result);
    }

    private void findMembers(TM1Hierarchy hierarchy, List<TM1Member> result) {
        if (null != this.mLevelNumber) {
            int levelNumber = this.mLevelNumber;
            if (levelNumber == 0) {
                if (this.dimProperties != null && this.dimProperties.length > 0) {
                    result.addAll(this.getLoader(this.getCubeLocales()).loadAccessibleRootMembers(hierarchy));
                } else {
                    result.addAll(hierarchy.getAccessibleRoots());
                }
                return;
            }
            if (hierarchy.isParentChild() && hierarchy.isRagged()) {
                List members = Collections.emptyList();
                result.addAll(members);
            } else {
                TM1Level level = hierarchy.findLevel(levelNumber);
                if (null != level) {
                    this.getLoader(this.getCubeLocales()).loadLevelMembers(level, this.dimProperties, this.mRangeFrom, this.mRangeSize, this.mDataQuery, result);
                }
            }
        } else {
            this.getLoader(this.getCubeLocales()).loadHierarchyMembers(hierarchy, this.dimProperties, this.mRangeFrom, this.mRangeSize, result);
        }
    }

    private void memberSearch(TM1Cube cube, Set<TreeOperator> treeOps, Set<QueryMode> queryModes, List<TM1Member> result) throws TM1RESTODPException {
        if (null == treeOps) {
            throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionMissing, RestrictionType.TREEOP.toString());
        }
        TM1RESTMetadata metadata = null;
        if (null != this.mMUN) {
            metadata = TM1Utils.findMetadata(this.getSession(), cube, this.mMUN);
            if (null == metadata) {
                return;
            }
        } else if (null != this.mLUN) {
            metadata = TM1Utils.findLevel(cube, this.mLUN, true);
        } else if (null != this.mHUN) {
            metadata = TM1Utils.findHierarchy(cube, this.mHUN, true);
            if (null != metadata && null != this.mLevelNumber) {
                metadata = ((TM1Hierarchy)metadata).findLevel(this.mLevelNumber);
            }
        } else {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Member search context was not specified.");
        }
        this.getLoader(this.getCubeLocales()).loadMemberSearch(metadata, this.mSearchCriteria, treeOps, queryModes, this.dimProperties, this.mRangeFrom, this.mRangeSize, result);
    }

    public static MemberRecord buildRecord(TM1Member member) {
        return MemberRecordQuery.buildRecord(member, new HashMap<String, String>());
    }

    public static MemberRecord buildRecord(TM1Member member, Map<String, String> propNameToUniqueName) {
        TM1Level level = member.getLevel();
        TM1Hierarchy hierarchy = level.getHierarchy();
        TM1Dimension dimension = hierarchy.getDimension();
        TM1Cube cube = dimension.getCube();
        MemberRecord record = new MemberRecord();
        record.setCatalogName("CATALOG");
        record.setCubeName(cube.getName());
        record.setDimensionUniqueName(dimension.getUniqueName());
        record.setHierarchyUniqueName(hierarchy.getUniqueName());
        record.setLevelNumber((int)member.getLevelNumber());
        record.setLevelUniqueName(level.getUniqueName());
        record.setName(member.getName());
        record.setUniqueName(member.getUniqueName());
        record.setDescription(member.getDescription());
        record.setChildCardinality((int)member.getChildrenCardinality());
        record.setRollupType(RollupTypeEnum.ROLLUP);
        record.setUniqueId(member.getName());
        record.setDynamicField("PPDS_KEY", (Object)member.getName());
        if (null != member.getParentMUN() && member.getParentMUN().length() > 0) {
            record.setParentCount(1);
            record.setParentUniqueName(member.getParentMUN());
            record.setParentLevelNumber(record.getLevelNumber() - 1);
        } else {
            record.setParentCount(0);
            record.setParentLevelNumber(-1);
        }
        record.setCaption((ILocalizedString)member.getLocalizedCaption());
        Map<String, Object> dynamicFields = member.getDynamicFields();
        for (Map.Entry<String, Object> prop : dynamicFields.entrySet()) {
            if (propNameToUniqueName.containsKey(prop.getKey())) {
                String propUniqueName = propNameToUniqueName.get(prop.getKey());
                record.setDynamicField(propUniqueName, prop.getValue());
                continue;
            }
            record.setDynamicField(prop.getKey(), prop.getValue());
        }
        Object memberKey = dynamicFields.get("MEMBER_KEY");
        if (memberKey == null || memberKey.toString().isEmpty() || memberKey instanceof Value && ((Value)memberKey).isNull()) {
            record.setDynamicField("MEMBER_KEY", (Object)TM1Utils.extractLastUniqueNamePart(member.getUniqueName()));
        }
        return record;
    }

    private static EnumSet<TreeOperator> convertTreeOps(EnumSet<TreeOperatorEnum> xqeTreeOps) {
        EnumSet<TreeOperator> result = EnumSet.noneOf(TreeOperator.class);
        block8: for (TreeOperatorEnum op : xqeTreeOps) {
            switch (op) {
                case ANCESTORS: {
                    result.add(TreeOperator.Ancestors);
                    continue block8;
                }
                case CHILDREN: {
                    result.add(TreeOperator.Children);
                    continue block8;
                }
                case DESCENDANTS: {
                    result.add(TreeOperator.Descendants);
                    continue block8;
                }
                case PARENT: {
                    result.add(TreeOperator.Parent);
                    continue block8;
                }
                case SELF: {
                    result.add(TreeOperator.Self);
                    continue block8;
                }
                case SIBLINGS: {
                    result.add(TreeOperator.Siblings);
                    continue block8;
                }
            }
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Unsupported TreeOperatorEnum: " + op.toString());
        }
        return result;
    }

    @Override
    public void release() {
    }
}

