/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.metadata.query;

import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTMessageKeys;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTODPException;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Cube;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Dimension;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Hierarchy;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1NamedSet;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadataSession;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.query.MetadataQuery;
import com.cognos.xqe.data.providers.olap.tm1rest.utils.TM1Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NamedSetLevelUniqueNamesRecordQuery
extends MetadataQuery<String> {
    private String mCubeName = null;
    private String mDUN = null;
    private String mHUN = null;
    private String mNSUN = null;

    public NamedSetLevelUniqueNamesRecordQuery(TM1RESTMetadataSession session) {
        super(session);
    }

    public void setCubeName(String cubeName) {
        this.mCubeName = cubeName;
    }

    public void setDUN(String dun) {
        this.mDUN = dun;
    }

    public void setHUN(String hun) {
        this.mHUN = hun;
    }

    public void setNSUN(String nsun) {
        this.mNSUN = nsun;
    }

    @Override
    public List<String> execute() {
        this.checkRangeRestrictions();
        if (null == this.mCubeName) {
            NamedSetLevelUniqueNamesRecordQuery.throwRestrictionMissing(RestrictionType.CUBE);
        }
        if (this.mRangeSize < 1) {
            return Collections.emptyList();
        }
        TM1Cube cube = this.getLoader(this.getCubeLocales()).loadCube(this.mCubeName, this.getCubeCache());
        if (null == cube) {
            throw new TM1RESTODPException(TM1RESTMessageKeys.MET_CANNOT_FIND_CUBE, this.mCubeName);
        }
        if (null == this.mNSUN) {
            NamedSetLevelUniqueNamesRecordQuery.throwRestrictionMissing(RestrictionType.SET);
        }
        TM1NamedSet namedSet = null;
        if (this.mHUN != null) {
            TM1Hierarchy hierarchy = TM1Utils.findHierarchy(cube, this.mHUN, false);
            if (null != hierarchy) {
                namedSet = hierarchy.getNamedSet(this.mNSUN);
            }
        } else if (this.mDUN != null) {
            TM1Dimension dimension = TM1Utils.findDimension(cube, this.mDUN, false);
            if (null != dimension) {
                namedSet = dimension.getNamedSet(this.mNSUN);
            }
        } else {
            namedSet = TM1Utils.findNamedSet(cube, this.mNSUN, false);
        }
        if (null == namedSet) {
            return Collections.emptyList();
        }
        ArrayList<String> levelUniqueNames = new ArrayList<String>();
        this.getLoader(this.getCubeLocales()).loadNamedSetLevelsEx(namedSet, levelUniqueNames);
        return levelUniqueNames;
    }
}

