/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.restclient;

import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.HeaderGroup;

public class BaseHttpClientConfig {
    private static final String COOKIE = "cookie";
    protected Map<String, Header> requestHeaders = new HashMap<String, Header>();
    protected static final HeaderGroup HOPBYHOPHEADERS;
    protected static final HeaderGroup IGNOREREQUESTHEADERS;

    public void setRequestHeader(String name, String value) {
        if (value == null) {
            this.requestHeaders.remove(name.toLowerCase());
        } else {
            this.requestHeaders.put(name.toLowerCase(), (Header)new BasicHeader(name, value));
        }
    }

    public void clearRequestHeaders() {
        this.requestHeaders.clear();
    }

    public Collection<Header> getRequestHeaders() {
        return this.requestHeaders.values();
    }

    public Header getRequestHeader(String name) {
        return this.requestHeaders.get(name.toLowerCase());
    }

    public List<HttpCookie> getCookies() {
        Header cookieHeader = this.getRequestHeader(COOKIE);
        ArrayList<HttpCookie> cookies = new ArrayList<HttpCookie>();
        if (cookieHeader != null && cookieHeader.getValue() != null && !cookieHeader.getValue().isEmpty()) {
            String[] cookieStrings;
            for (String cookieString : cookieStrings = cookieHeader.getValue().split(";")) {
                HttpCookie cookie = HttpCookie.parse(cookieString).get(0);
                cookies.add(cookie);
            }
        }
        return cookies;
    }

    public void setCookies(List<HttpCookie> cookies) {
        StringBuilder cookieHeaderValue = new StringBuilder();
        if (cookies != null) {
            Iterator<HttpCookie> it = cookies.iterator();
            while (it.hasNext()) {
                cookieHeaderValue.append(it.next().toString());
                if (!it.hasNext()) continue;
                cookieHeaderValue.append("; ");
            }
        }
        this.setRequestHeader(COOKIE, cookieHeaderValue.toString());
    }

    public void setCookie(HttpCookie acookie) {
        List<HttpCookie> cookies = this.getCookies();
        for (HttpCookie cookie : cookies) {
            if (!acookie.getName().equals(cookie.getName())) continue;
            if (cookie.getValue().equals(acookie.getValue())) {
                return;
            }
            cookies.remove(cookie);
            break;
        }
        if (acookie.getValue() != null) {
            cookies.add(acookie);
        }
        this.setCookies(cookies);
    }

    static {
        String[] headers;
        HOPBYHOPHEADERS = new HeaderGroup();
        for (String header : headers = new String[]{"Connection", "Keep-Alive", "Proxy-Authenticate", "Proxy-Authorization", "TE", "Trailers", "Transfer-Encoding", "Upgrade"}) {
            HOPBYHOPHEADERS.addHeader((Header)new BasicHeader(header, null));
        }
        IGNOREREQUESTHEADERS = new HeaderGroup();
        for (String header : headers = new String[]{"Content-Length", "Content-Type", "Accept-Encoding", "Host", "Referer", "Pragma", "X-Requested-With", "Cache-Control", "User-Agent", "X-Forwarded-For", "X-Forwarded-Host", "X-Forwarded-Proto", "Forwarded"}) {
            IGNOREREQUESTHEADERS.addHeader((Header)new BasicHeader(header, null));
        }
    }
}

