/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.restclient;

import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonArray;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonArrayStream;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonObject;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClient;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import java.util.Iterator;
import java.util.Locale;

public class JsonArrayStream
implements IJsonArrayStream {
    private IJsonArray mJsonArrayChunk;
    private long mCardinality = -1L;
    private long mChunkOrdinal = 0L;
    private final String mResourceUri;
    private final RESTClient mRestClient;
    private final ExecutionEnvironment mExecEnv;
    private final Locale mLocale;
    private final int mChunkSize = 16384;

    public JsonArrayStream(RESTClient restClient, ExecutionEnvironment execEnv, String resourceUri, long cardinality, Locale locale) {
        this.mRestClient = restClient;
        this.mExecEnv = execEnv;
        this.mResourceUri = resourceUri;
        this.mCardinality = cardinality;
        this.mLocale = locale;
        this.mJsonArrayChunk = this.getChunkArray(0L);
    }

    @Override
    public long size() {
        return this.mCardinality;
    }

    @Override
    public boolean isEmpty() {
        return 0L == this.size();
    }

    @Override
    public IJsonObject get(int index) throws IndexOutOfBoundsException {
        this.checkBounds(index);
        long chunkOrdinal = index / 16384;
        if (chunkOrdinal != this.mChunkOrdinal) {
            this.mJsonArrayChunk = this.getChunkArray(chunkOrdinal);
        }
        long chunkIndex = (long)index - this.mChunkOrdinal * 16384L;
        return (IJsonObject)this.mJsonArrayChunk.get((int)chunkIndex);
    }

    @Override
    public Iterator<IJsonObject> iterator() {
        return new Iter();
    }

    private IJsonArray getChunkArray(long chunkOrdinal) {
        this.mChunkOrdinal = chunkOrdinal;
        if (-1L == this.mCardinality) {
            int qPos = this.mResourceUri.lastIndexOf(63);
            StringBuilder countUri = new StringBuilder();
            if (-1 == qPos) {
                countUri.append(this.mResourceUri);
            } else {
                countUri.append(this.mResourceUri.substring(0, qPos));
            }
            countUri.append("/$count");
            String textResource = this.mRestClient.getTextResource(countUri.toString());
            this.mCardinality = Long.parseLong(textResource);
        }
        StringBuilder chunkUri = new StringBuilder(this.mResourceUri);
        chunkUri.append("&$skip=").append(chunkOrdinal * 16384L);
        chunkUri.append("&$top=").append(16384);
        IJsonObject jsonChunk = this.mRestClient.getJsonResource(chunkUri.toString(), this.mExecEnv, this.mLocale, "application/json;odata.metadata=none");
        return jsonChunk.getArray("value");
    }

    protected void checkBounds(int index) throws IndexOutOfBoundsException {
        if (index < 0 || (long)index > this.size()) {
            throw new IndexOutOfBoundsException("index = " + index);
        }
    }

    private final class Iter
    implements Iterator<IJsonObject> {
        private int nextIndex = 0;

        private Iter() {
        }

        @Override
        public boolean hasNext() {
            return (long)this.nextIndex < JsonArrayStream.this.size();
        }

        @Override
        public IJsonObject next() {
            if (!this.hasNext()) {
                return null;
            }
            return JsonArrayStream.this.get(this.nextIndex++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

