/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.restclient;

public final class ODataFilter {
    private static final String QUOTE = "'";
    private static final String OPEN_BRACKET = "(";
    private static final String CLOSED_BRACKET = ")";

    private ODataFilter() {
    }

    public static String eq(String left, Object right) {
        return ODataFilter.expression(left, LogicalOperator.EQUALS, right);
    }

    public static String eql(String left, Object right) {
        return ODataFilter.literalExpression(left, LogicalOperator.EQUALS, right);
    }

    public static String ne(String left, Object right) {
        return ODataFilter.expression(left, LogicalOperator.NOT_EQUALS, right);
    }

    public static String nel(String left, Object right) {
        return ODataFilter.literalExpression(left, LogicalOperator.NOT_EQUALS, right);
    }

    public static String gt(String left, Object right) {
        return ODataFilter.expression(left, LogicalOperator.GREATER_THAN, right);
    }

    public static String gtl(String left, Object right) {
        return ODataFilter.literalExpression(left, LogicalOperator.GREATER_THAN, right);
    }

    public static String ge(String left, Object right) {
        return ODataFilter.expression(left, LogicalOperator.GREATER_OR_EQUAL, right);
    }

    public static String gel(String left, Object right) {
        return ODataFilter.literalExpression(left, LogicalOperator.GREATER_OR_EQUAL, right);
    }

    public static String lt(String left, Object right) {
        return ODataFilter.expression(left, LogicalOperator.LESS_THAN, right);
    }

    public static String ltl(String left, Object right) {
        return ODataFilter.literalExpression(left, LogicalOperator.LESS_THAN, right);
    }

    public static String le(String left, Object right) {
        return ODataFilter.expression(left, LogicalOperator.LESS_OR_EQUAL, right);
    }

    public static String lel(String left, Object right) {
        return ODataFilter.literalExpression(left, LogicalOperator.LESS_OR_EQUAL, right);
    }

    public static String and(String left, String right) {
        return ODataFilter.expression(left, LogicalOperator.AND, right);
    }

    public static String or(String left, String right) {
        return ODataFilter.expression(left, LogicalOperator.OR, right);
    }

    public static String not(String operand) {
        StringBuilder builder = new StringBuilder(OPEN_BRACKET);
        builder.append(LogicalOperator.NOT.getToken()).append(operand).append(CLOSED_BRACKET);
        return builder.toString();
    }

    private static String expression(String left, LogicalOperator operator, Object right) {
        StringBuilder builder = new StringBuilder(OPEN_BRACKET);
        builder.append(left).append(operator.getToken()).append(right.toString()).append(CLOSED_BRACKET);
        return builder.toString();
    }

    private static String literalExpression(String param, LogicalOperator operator, Object value) {
        StringBuilder builder = new StringBuilder(OPEN_BRACKET);
        builder.append(param).append(operator.getToken()).append(QUOTE).append(value.toString()).append(QUOTE).append(CLOSED_BRACKET);
        return builder.toString();
    }

    public static enum LogicalOperator {
        EQUALS("%20eq%20"),
        NOT_EQUALS("%20ne%20"),
        GREATER_THAN("%20gt%20"),
        GREATER_OR_EQUAL("%20ge%20"),
        LESS_THAN("%20lt%20"),
        LESS_OR_EQUAL("%20le%20"),
        AND("%20and%20"),
        OR("%20or%20"),
        NOT("not%20");

        private final String mToken;

        private LogicalOperator(String token) {
            this.mToken = token;
        }

        public String getToken() {
            return this.mToken;
        }
    }
}

