/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.restclient;

import com.cognos.xqe.data.providers.olap.tm1rest.restclient.ODataFilter;
import com.cognos.xqe.exception.XQERuntimeException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class ODataUriBuilder {
    private static final String DEF_SERVICE_ROOT = "/api/v1/";
    private static final String PARAM_BEGIN = "('";
    private static final String PUSH = "(";
    private static final String POP = ")";
    private static final String PARAM_END = "')";
    private static final String SLASH = "/";
    private static final String QUOTE = "'";
    private static final String COMMA = ",";
    private static final String AMPERSAND = "&";
    private static final String QUESTION_MARK = "?";
    private static final String SEMICOLON = ";";
    private static final String RAW_VALUE = "$value";
    private static final String SELECT = "$select=";
    private static final String EXPAND = "$expand=";
    private static final String FILTER = "$filter=";
    private static final String TOP = "$top=";
    private static final String SKIP = "$skip=";
    private static final String COUNT = "$count";
    private static final String SPACE = "%20";
    private static final String TOUPPER = "toupper";
    private static final String ACTION_PREFIX = "tm1.";
    private StringBuilder mBuffer = null;
    private Boolean mQueryOptions = false;
    private Boolean mAddEntitySeparator = false;
    private Boolean mAddSeparator = false;
    private int mNestedOptions = 0;
    private Deque<Boolean> mExpandPipe = new ArrayDeque<Boolean>();
    private Deque<Boolean> mSelectPipe = new ArrayDeque<Boolean>();
    private Deque<Boolean> mFilterAttributePipe = new ArrayDeque<Boolean>();
    private final String mServiceRoot;

    protected ODataUriBuilder() {
        this(DEF_SERVICE_ROOT);
    }

    protected ODataUriBuilder(String serviceRoot) {
        this.mServiceRoot = serviceRoot;
        this.mBuffer = new StringBuilder(this.mServiceRoot);
        this.initPipes();
    }

    public ODataUriBuilder action(String action) {
        this.appendEntitySeparator();
        this.mBuffer.append(ACTION_PREFIX).append(action);
        return this;
    }

    public ODataUriBuilder entity(String entity) {
        this.appendEntitySeparator();
        this.mBuffer.append(entity);
        return this;
    }

    public ODataUriBuilder entityId(String entity, String id) {
        this.appendEntitySeparator();
        String escapedId = ODataUriBuilder.escapeChar(id, '\'', '\'');
        String decodedId = StringEscapeUtils.unescapeXml((String)escapedId);
        this.mBuffer.append(entity).append(PARAM_BEGIN).append(decodedId).append(PARAM_END);
        return this;
    }

    public ODataUriBuilder entityId(String entity, long id) {
        this.appendEntitySeparator();
        this.mBuffer.append(entity).append(PUSH).append(id).append(POP);
        return this;
    }

    public ODataUriBuilder rvalue() {
        this.mBuffer.append(SLASH).append(RAW_VALUE);
        return this;
    }

    public ODataUriBuilder select(String ... properties) {
        this.appendQueryOption(this.mSelectPipe.peekFirst());
        if (!this.mSelectPipe.peekFirst().booleanValue()) {
            this.mBuffer.append(SELECT);
            this.mSelectPipe.removeFirst();
            this.mSelectPipe.addFirst(true);
        }
        this.mBuffer.append(StringUtils.join((Object[])properties, (char)','));
        return this;
    }

    public ODataUriBuilder filterAttributes(String property, String condition, String operator, List<String> values, boolean isCaseInsensitive) {
        this.appendQueryOption(this.mFilterAttributePipe.peekFirst());
        if (!this.mFilterAttributePipe.peekFirst().booleanValue()) {
            this.mBuffer.append(FILTER);
            this.mFilterAttributePipe.removeFirst();
            this.mFilterAttributePipe.addFirst(true);
        }
        boolean addOperator = false;
        for (String value : values) {
            String searchValue;
            try {
                searchValue = URLEncoder.encode(value, "UTF-8").replace("+", SPACE);
            }
            catch (UnsupportedEncodingException ex) {
                throw new XQERuntimeException((Throwable)ex);
            }
            if (addOperator) {
                if (operator == null) {
                    throw new XQERuntimeException();
                }
                this.mBuffer.append(SPACE).append(operator).append(SPACE);
            } else {
                addOperator = true;
            }
            boolean addFunction = false;
            if (!condition.equals("eq") && !condition.equals("neq")) {
                addFunction = true;
                this.mBuffer.append(condition).append(PUSH);
            }
            if (isCaseInsensitive) {
                this.mBuffer.append(TOUPPER).append(PUSH);
                searchValue = searchValue.toUpperCase();
            }
            this.mBuffer.append("Attributes");
            this.appendEntitySeparator();
            this.mBuffer.append(property);
            if (isCaseInsensitive) {
                this.mBuffer.append(POP);
            }
            if (addFunction) {
                this.mBuffer.append(COMMA).append(SPACE).append(QUOTE).append(searchValue).append(QUOTE).append(POP);
                continue;
            }
            this.mBuffer.append(SPACE).append(condition).append(SPACE).append(QUOTE).append(searchValue).append(QUOTE);
        }
        return this;
    }

    public ODataUriBuilder filter(String filterExpression) {
        this.appendQueryOption();
        this.mBuffer.append(FILTER).append(filterExpression);
        return this;
    }

    public ODataUriBuilder filterEq(String left, String right) {
        this.appendQueryOption();
        this.mBuffer.append(FILTER).append(ODataFilter.eq(left, right));
        return this;
    }

    public ODataUriBuilder filterGt(String left, Object right) {
        this.appendQueryOption();
        this.mBuffer.append(FILTER).append(ODataFilter.gt(left, right));
        return this;
    }

    public ODataUriBuilder filterEq(String left, int right) {
        this.appendQueryOption();
        this.mBuffer.append(FILTER).append(left).append(ODataFilter.LogicalOperator.EQUALS.getToken()).append(right);
        return this;
    }

    public ODataUriBuilder filterNe(String left, String right) {
        this.appendQueryOption();
        this.mBuffer.append(FILTER).append(left).append(ODataFilter.LogicalOperator.NOT_EQUALS.getToken()).append(QUOTE).append(right).append(QUOTE);
        return this;
    }

    public ODataUriBuilder filterNe(String left, int right) {
        this.appendQueryOption();
        this.mBuffer.append(FILTER).append(left).append(ODataFilter.LogicalOperator.NOT_EQUALS.getToken()).append(right);
        return this;
    }

    public ODataUriBuilder expand(String ... entities) {
        this.appendQueryOption(this.mExpandPipe.peekFirst());
        if (!this.mExpandPipe.peekFirst().booleanValue()) {
            this.mBuffer.append(EXPAND);
            this.mExpandPipe.removeFirst();
            this.mExpandPipe.addFirst(true);
        }
        this.mBuffer.append(StringUtils.join((Object[])entities, (char)','));
        return this;
    }

    public ODataUriBuilder top(long number) {
        this.appendQueryOption();
        this.mBuffer.append(TOP).append(number);
        return this;
    }

    public ODataUriBuilder skip(long number) {
        this.appendQueryOption();
        this.mBuffer.append(SKIP).append(number);
        return this;
    }

    public ODataUriBuilder count() {
        this.appendQueryOption();
        this.mBuffer.append(COUNT);
        return this;
    }

    public ODataUriBuilder push() {
        this.mBuffer.append(PUSH);
        this.mAddSeparator = false;
        ++this.mNestedOptions;
        this.initPipes();
        return this;
    }

    public ODataUriBuilder pop() {
        this.mBuffer.append(POP);
        if (--this.mNestedOptions == 0) {
            this.mAddSeparator = false;
        }
        this.popPipes();
        return this;
    }

    public ODataUriBuilder reset() {
        this.mQueryOptions = false;
        this.mAddEntitySeparator = false;
        this.mNestedOptions = 0;
        this.mAddSeparator = false;
        this.resetPipes();
        this.mBuffer.setLength(0);
        this.mBuffer.append(this.mServiceRoot);
        return this;
    }

    private ODataUriBuilder appendEntitySeparator() {
        if (this.mAddEntitySeparator.booleanValue()) {
            this.mBuffer.append(SLASH);
        } else {
            this.mAddEntitySeparator = true;
        }
        return this;
    }

    private ODataUriBuilder appendQueryOption() {
        return this.appendQueryOption(false);
    }

    private ODataUriBuilder appendQueryOption(boolean pipe) {
        if (this.mQueryOptions.booleanValue()) {
            if (this.mNestedOptions > 0) {
                if (this.mAddSeparator.booleanValue()) {
                    if (pipe) {
                        this.mBuffer.append(COMMA);
                    } else {
                        this.mBuffer.append(SEMICOLON);
                    }
                } else {
                    this.mAddSeparator = true;
                }
            } else if (pipe) {
                this.mBuffer.append(COMMA);
            } else {
                this.mBuffer.append(AMPERSAND);
            }
            return this;
        }
        this.mQueryOptions = true;
        this.mBuffer.append(QUESTION_MARK);
        return this;
    }

    private void initPipes() {
        this.mExpandPipe.addFirst(false);
        this.mSelectPipe.addFirst(false);
        this.mFilterAttributePipe.addFirst(false);
    }

    private void popPipes() {
        this.mExpandPipe.removeFirst();
        this.mSelectPipe.removeFirst();
        this.mFilterAttributePipe.removeFirst();
    }

    private void resetPipes() {
        this.mExpandPipe.clear();
        this.mSelectPipe.clear();
        this.mFilterAttributePipe.clear();
        this.initPipes();
    }

    public String toString() {
        return this.mBuffer.toString();
    }

    public static String escapeChar(String source, char escapeChar, char withChar) {
        int length = source.length();
        char[] result = new char[length * 2];
        char[] sourceArray = source.toCharArray();
        int index = 0;
        for (int i = 0; i < length; ++i) {
            if (sourceArray[i] == escapeChar) {
                result[index++] = withChar;
            }
            result[index++] = sourceArray[i];
        }
        if (index == length) {
            return source;
        }
        return new String(result, 0, index);
    }

    public static String encodeUriEntity(String entityId) {
        String escapedId = ODataUriBuilder.escapeChar(entityId, '\'', '\'');
        return StringEscapeUtils.unescapeXml((String)escapedId);
    }
}

