/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.restclient;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;

class RESTClientFactoryConfig {
    private static final String ENHANCED_NETWORK_ERRORS_HANDLING = "queryExecution.TM1RESTClientENEHandling[@enabled]";
    private static final String USE_FIDDLER_PROXY_CONFIG = "queryExecution.useFiddlerProxyForTM1RESTClient[@enabled]";
    private static final int DEFAULT_HTTP_CLIENT_SOCKET_TIMEOUT = 300;
    private static final String HTTP_CLIENT_SOCKET_TIMEOUT_CONFIG = "queryExecution.TM1RESTClientSocketTimeout[@value]";
    private static final int DEFAULT_HTTP_CLIENT_IDLE_CONNECTION_TIMEOUT = 200;
    private static final String HTTP_CLIENT_IDLE_CONNECTION_TIMEOUT_CONFIG = "queryExecution.TM1RESTClientIdleConnectionTimeout[@value]";
    private static final int DEFAULT_HTTP_CLIENT_CONNECTION_TIMEOUT = 5000;
    private static final String HTTP_CLIENT_CONNECTION_TIMEOUT_CONFIG = "queryExecution.TM1RESTClientConnectionTimeout[@value]";

    private RESTClientFactoryConfig() {
    }

    public static boolean useFiddlerProxyForTM1RESTClient() {
        XQEConfiguration xqeConfiguration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        return xqeConfiguration.getBooleanProperty(USE_FIDDLER_PROXY_CONFIG, false);
    }

    public static int getHttpClientSocketTimeout() {
        XQEConfiguration xqeConfiguration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        int socketTimeoutInSeconds = xqeConfiguration.getIntProperty(HTTP_CLIENT_SOCKET_TIMEOUT_CONFIG, 300);
        return socketTimeoutInSeconds * 1000;
    }

    public static int getHttpClientIdleConnectionTimeout() {
        XQEConfiguration xqeConfiguration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        return xqeConfiguration.getIntProperty(HTTP_CLIENT_IDLE_CONNECTION_TIMEOUT_CONFIG, 200);
    }

    public static int getHttpClientConnectionTimeout() {
        XQEConfiguration xqeConfiguration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        return xqeConfiguration.getIntProperty(HTTP_CLIENT_CONNECTION_TIMEOUT_CONFIG, 5000);
    }

    public static boolean useEnhancedNetworkErrorsHandling() {
        XQEConfiguration xqeConfiguration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        return xqeConfiguration.getBooleanProperty(ENHANCED_NETWORK_ERRORS_HANDLING, true);
    }
}

