/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.restclient;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTLog;
import com.cognos.xqe.trace.LogLevel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.conn.ssl.TrustStrategy;

public class TrustKnownSelfSignedStrategy
implements TrustStrategy {
    private static final String TM1_CONNECTION_FACTORY_FAILED_TO_LOAD_CERTIFICATES = "TM1ConnectionFactory(): failed to load certificates. %s";
    private static final String TM1_CONNECTION_FACTORY_UNKNOWN_CERTIFICATE = "TrustKnownSelfSignedStrategy.isTrusted(): Unknown certificate. Serial Number [%s], Issuer [%s].";
    private static final int RADIX_16 = 16;
    private static boolean mValidateSelfSignedCertificates = true;
    private static boolean mIgnoreValidateSelfSignedCertificates = false;
    private static String mChangeit = "Y2hhbmdlaXQ=";
    private static Map<BigInteger, List<String>> mSNDN = new HashMap<BigInteger, List<String>>();
    private static ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (1 != chain.length) {
            return false;
        }
        if (mIgnoreValidateSelfSignedCertificates || !mValidateSelfSignedCertificates) {
            return true;
        }
        BigInteger serialNumber = chain[0].getSerialNumber();
        String issuer = chain[0].getIssuerX500Principal().getName();
        readWriteLock.readLock().lock();
        try {
            List<String> dnset = mSNDN.get(serialNumber);
            if (null == dnset) {
                TrustKnownSelfSignedStrategy.logUnknownCertificate(serialNumber, issuer);
                boolean bl = false;
                return bl;
            }
            if (!dnset.contains(issuer)) {
                TrustKnownSelfSignedStrategy.logUnknownCertificate(serialNumber, issuer);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDefaultKeyStore() throws KeyStoreException {
        mValidateSelfSignedCertificates = TrustKnownSelfSignedStrategy.getValidateSelfSignedCertificateConfig();
        if (!mValidateSelfSignedCertificates) {
            return;
        }
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream fis = null;
        try {
            String filename = System.getProperty("java.home") + "/lib/security/cacerts".replace('/', File.separatorChar);
            fis = new FileInputStream(filename);
            byte[] changeitdecoded = Base64.decodeBase64((byte[])mChangeit.getBytes());
            keystore.load(fis, new String(changeitdecoded).toCharArray());
            TrustKnownSelfSignedStrategy.registerCertificates(keystore);
        }
        catch (IOException ioException) {
            TrustKnownSelfSignedStrategy.logExceptionMessage(ioException.getLocalizedMessage());
            mIgnoreValidateSelfSignedCertificates = true;
        }
        catch (NoSuchAlgorithmException nsaException) {
            TrustKnownSelfSignedStrategy.logExceptionMessage(nsaException.getLocalizedMessage());
            mIgnoreValidateSelfSignedCertificates = true;
        }
        catch (CertificateException cerException) {
            TrustKnownSelfSignedStrategy.logExceptionMessage(cerException.getLocalizedMessage());
            mIgnoreValidateSelfSignedCertificates = true;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioEx) {
                    TrustKnownSelfSignedStrategy.logExceptionMessage(ioEx.getLocalizedMessage());
                }
            }
        }
    }

    private static void registerCertificates(KeyStore keystore) throws KeyStoreException {
        Enumeration<String> aliases = keystore.aliases();
        while (aliases.hasMoreElements()) {
            Certificate certificate;
            String alias = aliases.nextElement();
            if (keystore.isKeyEntry(alias) || null == (certificate = keystore.getCertificate(alias)) || !"X.509".equals(certificate.getType())) continue;
            TrustKnownSelfSignedStrategy.registerCertificate((X509Certificate)certificate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerCertificate(X509Certificate x509Certificate) {
        BigInteger sn = x509Certificate.getSerialNumber();
        X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
        readWriteLock.writeLock().lock();
        try {
            List<String> dnlist = mSNDN.get(sn);
            if (null == dnlist) {
                dnlist = new ArrayList<String>();
                mSNDN.put(sn, dnlist);
            }
            dnlist.add(x500Principal.getName());
        }
        finally {
            readWriteLock.writeLock().unlock();
        }
    }

    private static boolean getValidateSelfSignedCertificateConfig() {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        return configuration.getBooleanProperty("queryExecution.validateTM1RESTSelfSignedCertificates[@enabled]", true);
    }

    private static void logExceptionMessage(String message) {
        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_FACTORY, LogLevel.ERROR, TM1_CONNECTION_FACTORY_FAILED_TO_LOAD_CERTIFICATES, message);
    }

    private static void logUnknownCertificate(BigInteger serialNumber, String issuer) {
        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_FACTORY, LogLevel.ERROR, TM1_CONNECTION_FACTORY_UNKNOWN_CERTIFICATE, serialNumber.toString(16), issuer);
    }
}

