/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.security;

import com.cognos.xqe.security.EncryptedObject;
import com.cognos.xqe.security.IEncryptedObject;
import java.time.Instant;

public class OAuth2Token {
    private static final long OFFSET_SECONDS = 300L;
    private final IEncryptedObject<String> bearer;
    private Instant timeWhenExpires;

    public OAuth2Token(String token, long expiresIn) {
        this.bearer = new EncryptedObject((Object)token);
        this.timeWhenExpires = expiresIn > 300L ? Instant.now().plusSeconds(expiresIn - 300L) : Instant.now().plusSeconds(expiresIn);
    }

    public String getAccessToken() {
        return (String)this.bearer.decrypt();
    }

    public boolean hasExpired() {
        return Instant.now().isAfter(this.timeWhenExpires);
    }
}

