/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.utils;

import com.cognos.xqe.ast.maExp.MABlockConstraint;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Hierarchy;
import com.cognos.xqe.data.providers.olap.tm1rest.utils.TreeOperator;
import com.cognos.xqe.transformation.ma.provider.MASearchCriteria;
import java.util.List;
import java.util.Set;

public class MemberSearchMdxBuilder {
    private static final String MDX_TEMPLATE = "Filter( %s,\n\t\t%s)";
    private static final String DESCENDANTS_TEMPLATE = "Descendants(%s, %s.Level, AFTER)";
    private static final String INSTR_FUNC_TEMPLATE = "Instr(1, %s.CurrentMember.properties('%s'), '%s', %d)";
    private static final String LEN_POSITION_TEMPLATE = "(LEN(%s.CurrentMember.properties('%s')) - LEN('%s') + 1)";
    private static final String LEN_CHECK_TEMPLATE = "(LEN(%s.CurrentMember.properties('%s')) >= LEN('%s'))";
    private static final String EQUAL_OPERATOR = " = ";
    private static final String GREATER_OR_EQUAL_OPERATOR = " >= ";
    private static final String AND_LOGICAL_OPERATOR = " and \n";
    private static final String OR_LOGICAL_OPERATOR = " or \n";

    public static String buildMdxAtMember(String mun, TM1Hierarchy hierarchy, MASearchCriteria searchCriteria, Set<TreeOperator> treeOps) {
        StringBuilder expressionBuilder = new StringBuilder();
        if (treeOps.contains((Object)TreeOperator.Descendants)) {
            expressionBuilder.append(String.format(DESCENDANTS_TEMPLATE, mun, mun));
        } else if (treeOps.contains((Object)TreeOperator.Children)) {
            expressionBuilder.append("{ ").append(mun).append(".Children }");
        } else {
            expressionBuilder.append("{  ").append(mun).append("  }");
        }
        return String.format(MDX_TEMPLATE, expressionBuilder.toString(), MemberSearchMdxBuilder.buildFilterCondition(hierarchy.getUniqueName(), searchCriteria));
    }

    private static String buildFilterCondition(String hun, MASearchCriteria searchCriteria) {
        int iCaseSensitiveFlag = 0;
        if (searchCriteria.getCaseInsensitive()) {
            iCaseSensitiveFlag = 1;
        }
        List searchValues = searchCriteria.getSearchValues();
        MABlockConstraint.Operation operation = searchCriteria.getOperator();
        String propertyUniqueName = searchCriteria.getPropertyUniqueName();
        StringBuilder sb = new StringBuilder("");
        for (int i = 0; i < searchValues.size(); ++i) {
            if (i > 0) {
                if (MABlockConstraint.Operation.OR == operation) {
                    sb.append(OR_LOGICAL_OPERATOR);
                } else if (MABlockConstraint.Operation.AND == operation) {
                    sb.append(AND_LOGICAL_OPERATOR);
                }
            }
            sb.append(" ( ");
            switch (searchCriteria.getSearchCondition()) {
                case CONTAINS: {
                    sb.append(String.format(LEN_CHECK_TEMPLATE, hun, propertyUniqueName, searchValues.get(i)));
                    sb.append(AND_LOGICAL_OPERATOR);
                    sb.append(String.format(INSTR_FUNC_TEMPLATE, hun, propertyUniqueName, searchValues.get(i), iCaseSensitiveFlag));
                    sb.append(GREATER_OR_EQUAL_OPERATOR).append(1);
                    break;
                }
                case STARTS_WITH: {
                    sb.append(String.format(LEN_CHECK_TEMPLATE, hun, propertyUniqueName, searchValues.get(i)));
                    sb.append(AND_LOGICAL_OPERATOR);
                    sb.append(String.format(INSTR_FUNC_TEMPLATE, hun, propertyUniqueName, searchValues.get(i), iCaseSensitiveFlag));
                    sb.append(EQUAL_OPERATOR).append(1);
                    break;
                }
                case ENDS_WITH: {
                    sb.append(String.format(LEN_CHECK_TEMPLATE, hun, propertyUniqueName, searchValues.get(i)));
                    sb.append(AND_LOGICAL_OPERATOR);
                    sb.append(String.format(INSTR_FUNC_TEMPLATE, hun, propertyUniqueName, searchValues.get(i), iCaseSensitiveFlag));
                    sb.append(EQUAL_OPERATOR);
                    sb.append(String.format(LEN_POSITION_TEMPLATE, hun, propertyUniqueName, searchValues.get(i)));
                    break;
                }
            }
            sb.append(" ) ");
        }
        sb.append(" )");
        return sb.toString();
    }
}

