/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.utils;

import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTMessageKeys;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTODPException;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Attribute;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Cube;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Dimension;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Hierarchy;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Level;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1NamedSet;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadata;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadataSession;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadataType;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.query.MetadataQuery;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.TimestampValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.util.MapCast;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public final class TM1Utils {
    private static final int FOUR = 4;
    private static final int THREE = 3;
    private static final int TWO = 2;
    private static final String SIMPLE_DATE_FORMAT = "yyyy-MM-dd'T'hh:mm:ss.SSS'Z'";
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");

    private TM1Utils() {
    }

    public static TM1RESTMetadata findMetadata(TM1RESTMetadataSession metadataSession, TM1Cube cube, String v5UniqueName) {
        String[] parts;
        try {
            parts = UniqueNameParser.parse((String)v5UniqueName);
        }
        catch (UniqueNameParserException ex) {
            throw XQERuntimeException.wrap((Throwable)ex);
        }
        if (0 == parts.length || parts.length > 3) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Invalid unique name format: " + v5UniqueName);
        }
        String dun = UniqueNameGenerator.createSingleNamePart((String)parts[0]);
        TM1Dimension dimension = cube.findDimension(dun);
        if (null == dimension) {
            return null;
        }
        if (1 == parts.length) {
            return dimension;
        }
        String providerHUNorNUN = UniqueNameGenerator.appendUniqueName((String)dun, (String)parts[1]);
        TM1Hierarchy hierarchy = dimension.findHierarchy(providerHUNorNUN);
        if (null == hierarchy) {
            if (2 == parts.length) {
                return dimension.findNamedSet(providerHUNorNUN);
            }
            return null;
        }
        if (2 == parts.length) {
            return hierarchy;
        }
        String providerLUN = UniqueNameGenerator.appendUniqueName((String)providerHUNorNUN, (String)parts[2]);
        TM1Level level = hierarchy.findLevel(providerLUN);
        if (null == level) {
            return metadataSession.getLoader().loadSingleMember(hierarchy, parts[2], MetadataQuery.EMPTY_PROPERTY_ARRAY);
        }
        return level;
    }

    public static TM1Dimension findDimension(TM1Cube cube, String mddsDUN, boolean mustResolve) {
        TM1RESTMetadata metadata = TM1Utils.findMetadata(null, cube, mddsDUN);
        if (null == metadata || TM1RESTMetadataType.DIMENSION != metadata.getType()) {
            if (mustResolve) {
                throw new TM1RESTODPException(TM1RESTMessageKeys.MET_NONEXISTANT_DIMENSION, mddsDUN);
            }
            return null;
        }
        return (TM1Dimension)metadata;
    }

    public static TM1Hierarchy findHierarchy(TM1Cube cube, String mddsHUN, boolean mustResolve) {
        TM1RESTMetadata metadata = TM1Utils.findMetadata(null, cube, mddsHUN);
        if (null == metadata || TM1RESTMetadataType.HIERARCHY != metadata.getType()) {
            if (mustResolve) {
                throw new TM1RESTODPException(TM1RESTMessageKeys.MET_NONEXISTANT_HIERARCHY, mddsHUN);
            }
            return null;
        }
        return (TM1Hierarchy)metadata;
    }

    public static TM1Level findLevel(TM1Cube cube, String mddsLUN, boolean mustResolve) {
        TM1RESTMetadata metadata = TM1Utils.findMetadata(null, cube, mddsLUN);
        if (null == metadata || TM1RESTMetadataType.LEVEL != metadata.getType()) {
            if (mustResolve) {
                throw new TM1RESTODPException(TM1RESTMessageKeys.MET_NONEXISTANT_LEVEL, mddsLUN);
            }
            return null;
        }
        return (TM1Level)metadata;
    }

    public static TM1NamedSet findNamedSet(TM1Cube cube, String nsun, boolean mustResolve) {
        TM1NamedSet metadata;
        String[] parts;
        try {
            parts = UniqueNameParser.parse((String)nsun);
        }
        catch (UniqueNameParserException ex) {
            throw XQERuntimeException.wrap((Throwable)ex);
        }
        if (parts.length != 2 && parts.length != 3) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Invalid named set unique name format: " + nsun);
        }
        String dun = UniqueNameGenerator.createSingleNamePart((String)parts[0]);
        TM1Dimension dimension = cube.findDimension(dun);
        if (null == dimension) {
            if (mustResolve) {
                throw new TM1RESTODPException(TM1RESTMessageKeys.MET_NONEXISTANT_DIMENSION, dun);
            }
            return null;
        }
        if (2 == parts.length) {
            metadata = dimension.findNamedSet(nsun);
        } else {
            String hun = UniqueNameGenerator.appendUniqueName((String)dun, (String)parts[1]);
            TM1Hierarchy hierarchy = dimension.findHierarchy(hun);
            if (null == hierarchy) {
                if (mustResolve) {
                    throw new TM1RESTODPException(TM1RESTMessageKeys.MET_NONEXISTANT_HIERARCHY, hun);
                }
                return null;
            }
            metadata = hierarchy.getNamedSet(nsun);
        }
        if (null == metadata || TM1RESTMetadataType.NAMEDSET != ((TM1RESTMetadata)metadata).getType()) {
            if (mustResolve) {
                throw new TM1RESTODPException(TM1RESTMessageKeys.MET_NONEXISTANT_NAMEDSET, nsun);
            }
            return null;
        }
        return metadata;
    }

    public static TM1Attribute findAttribute(TM1Cube cube, String pun) {
        TM1Level level;
        TM1Hierarchy hierarchy;
        String[] parts;
        try {
            parts = UniqueNameParser.parse((String)pun);
        }
        catch (UniqueNameParserException ex) {
            throw XQERuntimeException.wrap((Throwable)ex);
        }
        if (parts.length < 2 || parts.length > 4) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Invalid PUN: " + pun);
        }
        String dun = UniqueNameGenerator.createSingleNamePart((String)parts[0]);
        TM1Dimension dimension = cube.findDimension(dun);
        if (null == dimension || dimension.isMeasureDimension()) {
            return null;
        }
        if (parts.length > 2) {
            String providerHUN = UniqueNameGenerator.appendUniqueName((String)dun, (String)parts[1]);
            hierarchy = dimension.findHierarchy(providerHUN);
            if (null == hierarchy) {
                return null;
            }
        } else {
            return dimension.findAttribute(parts[1]);
        }
        if (parts.length > 3) {
            if (hierarchy.isParentChild()) {
                level = null;
            } else {
                String providerLUN = UniqueNameGenerator.createUniqueName((String)parts[0], (String)parts[1], (String)parts[2]);
                level = hierarchy.findLevel(providerLUN);
            }
            if (null == level) {
                return null;
            }
        } else {
            return hierarchy.findAttribute(parts[2]);
        }
        return level.findAttribute(parts[3]);
    }

    public static String ceateProviderMUN(String providerHUN, String uniqueNameComponent) {
        StringBuilder buf = new StringBuilder(providerHUN.length() + uniqueNameComponent.length() + 3);
        buf.append(providerHUN).append(".[").append(uniqueNameComponent).append(']');
        return buf.toString();
    }

    public static String convertV5MUNToProviderMUN(String v5MUN) {
        String[] parts;
        try {
            parts = UniqueNameParser.parse((String)v5MUN);
        }
        catch (UniqueNameParserException ex) {
            throw XQERuntimeException.wrap((Throwable)ex);
        }
        if (parts.length != 3 && parts.length != 4) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Invalid MDDS MUN: " + v5MUN);
        }
        if (3 == parts.length) {
            return parts[2];
        }
        return parts[3];
    }

    public static String extractProviderDUNFromV5MUN(String v5MUN) {
        String[] parts;
        try {
            parts = UniqueNameParser.parse((String)v5MUN);
        }
        catch (UniqueNameParserException ex) {
            throw XQERuntimeException.wrap((Throwable)ex);
        }
        return UniqueNameGenerator.createSingleNamePart((String)parts[0]);
    }

    public static String extractProviderHUNFromV5MUN(String v5MUN) {
        String[] parts;
        try {
            parts = UniqueNameParser.parse((String)v5MUN);
        }
        catch (UniqueNameParserException ex) {
            throw XQERuntimeException.wrap((Throwable)ex);
        }
        return UniqueNameGenerator.createEscapedUniqueName((String)parts[0], (String)parts[1]);
    }

    public static String extractLastUniqueNamePart(String uniqueName) {
        try {
            return UniqueNameParser.parseLastIdentifier((String)uniqueName);
        }
        catch (UniqueNameParserException ex) {
            throw XQERuntimeException.wrap((Throwable)ex);
        }
    }

    public static TimestampValue getTimestampValue(String strDate) {
        Date date;
        SimpleDateFormat dateFormat = new SimpleDateFormat(SIMPLE_DATE_FORMAT);
        dateFormat.setTimeZone(UTC_TIME_ZONE);
        try {
            date = dateFormat.parse(strDate);
        }
        catch (ParseException e) {
            date = new Date();
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        TimestampValue value = DataValueFactory.createTimestampValue();
        value.set((Calendar)calendar);
        return value;
    }

    public static Date getDateValue(String strDate) {
        Date date;
        SimpleDateFormat dateFormat = new SimpleDateFormat(SIMPLE_DATE_FORMAT);
        dateFormat.setTimeZone(UTC_TIME_ZONE);
        try {
            date = dateFormat.parse(strDate);
        }
        catch (ParseException e) {
            date = new Date();
        }
        return date;
    }

    public static TimestampValue getCurrentTimestampValue() {
        Date date = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        TimestampValue value = DataValueFactory.createTimestampValue();
        value.set((Calendar)calendar);
        return value;
    }

    public static TimestampValue getTimestampValue(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        TimestampValue value = DataValueFactory.createTimestampValue();
        value.set((Calendar)calendar);
        return value;
    }

    public static String[] getDimenstionProperties(String dum) {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        XDataContext dataContext = execEnv.getDataContext();
        if (null == dataContext) {
            return MetadataQuery.EMPTY_PROPERTY_ARRAY;
        }
        Map dimProperties = MapCast.uncheckedCast((Map)((Map)dataContext.getProperty("axesDimensionProperties")));
        if (null == dimProperties) {
            return MetadataQuery.EMPTY_PROPERTY_ARRAY;
        }
        Set propertyList = (Set)dimProperties.get(dum);
        if (propertyList != null) {
            propertyList.addAll((Collection)dimProperties.get("nativeProperties"));
        } else {
            propertyList = (Set)dimProperties.get("nativeProperties");
        }
        if (null == propertyList) {
            return MetadataQuery.EMPTY_PROPERTY_ARRAY;
        }
        return propertyList.toArray(new String[0]);
    }

    public static Locale getNormalizedLocale(String languageCountry) {
        if (null == languageCountry) {
            throw new NullPointerException();
        }
        String[] tokens = languageCountry.split("-");
        String language = tokens.length > 0 ? tokens[0] : "";
        String country = tokens.length > 1 ? tokens[1] : "";
        return new Locale(language, country);
    }
}

