/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.annotation.decorations;

import com.ibm.bi.predict.dataaccess.Decorator;
import com.ibm.bi.predict.math.NumberFormatter;
import com.ibm.bi.predict.sa.execution.annotation.DecorationStrategy;
import com.ibm.bi.predict.sa.execution.annotation.MessageService;
import com.ibm.bi.predict.sa.execution.annotation.result.AnnotationResult;
import com.ibm.bi.predict.sa.execution.annotation.result.MeanResult;
import java.util.Locale;

public class AverageDecoration
implements DecorationStrategy<MeanResult.MeanData> {
    private static final String BUNDLE_NAME = "Predict_Smart_Annotations";
    private static final String AVERAGE_KEY = "AVERAGE_DECO";
    private final int decorationIndex;
    private final MessageService messages;

    public AverageDecoration(int decorationIndex, MessageService messages) {
        this.decorationIndex = decorationIndex;
        this.messages = messages;
    }

    @Override
    public void decorate(Decorator decorator, AnnotationResult<MeanResult.MeanData> result, Locale locale) {
        MeanResult.MeanData data = result.getResult();
        double mean = data.getMean();
        String responseName = data.getResponseName();
        decorator.decorateColumn(this.decorationIndex, "marker", (Number)mean);
        decorator.decorateColumn(this.decorationIndex, "markerCaption", this.getMeanDecoration(mean, locale));
        decorator.decorateColumn(this.decorationIndex, "tooltip", this.getTooltip(mean, responseName, locale));
    }

    private String getMeanDecoration(double mean, Locale locale) {
        return this.messages.getMessageBundle(BUNDLE_NAME, locale).getMessage("AVERAGE_DECO_SHORT", AverageDecoration.formatMean(mean, locale));
    }

    private String getTooltip(double mean, String responseName, Locale locale) {
        return this.messages.getMessageBundle(BUNDLE_NAME, locale).getMessage("AVERAGE_DECO_LONG", responseName, AverageDecoration.formatMean(mean, locale));
    }

    private static String formatMean(double mean, Locale locale) {
        return NumberFormatter.format((Locale)locale, (boolean)true, (double)mean);
    }
}

