/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.annotation.decorations;

import com.ibm.bi.predict.dataaccess.Decorator;
import com.ibm.bi.predict.sa.execution.annotation.DecorationStrategy;
import com.ibm.bi.predict.sa.execution.annotation.MessageService;
import com.ibm.bi.predict.sa.execution.annotation.result.AnnotationResult;
import com.ibm.bi.predict.sa.execution.annotation.result.PredictiveStrengthResult;
import com.ibm.bi.predict.sa.execution.api.messagesgenerator.MessagesGeneratorCommon;
import java.util.List;
import java.util.Locale;

public class PredictiveStrengthDecoration
implements DecorationStrategy<PredictiveStrengthResult.PredictiveStrengthData> {
    private static final String BUNDLE_NAME = "Predict_Smart_Annotations";
    private final MessageService messages;

    public PredictiveStrengthDecoration(MessageService messages) {
        this.messages = messages;
    }

    @Override
    public void decorate(Decorator decorator, AnnotationResult<PredictiveStrengthResult.PredictiveStrengthData> result, Locale locale) {
        if (result.isEmpty()) {
            return;
        }
        PredictiveStrengthResult.PredictiveStrengthData data = result.getResult();
        this.decorateTitle(data, decorator, locale);
        this.decorateTooltip(data, decorator, locale);
        this.decorateStatistics(data, decorator, locale);
    }

    private void decorateTitle(PredictiveStrengthResult.PredictiveStrengthData data, Decorator decorator, Locale locale) {
        PredictiveStrengthDecoration.decorate("predictive_strength_title", this.getPredictiveStrengthTitle(data, locale), decorator);
    }

    private void decorateTooltip(PredictiveStrengthResult.PredictiveStrengthData data, Decorator decorator, Locale locale) {
        PredictiveStrengthDecoration.decorate("tooltip", this.getPredictiveStrengthTooltip(data, locale), decorator);
    }

    private void decorateStatistics(PredictiveStrengthResult.PredictiveStrengthData data, Decorator decorator, Locale locale) {
        PredictiveStrengthDecoration.decorate("predictive_strength_p_value", data.pValue, decorator);
        PredictiveStrengthDecoration.decorate("predictive_strength", data.strength, decorator);
    }

    private String getPredictiveStrengthTitle(PredictiveStrengthResult.PredictiveStrengthData data, Locale locale) {
        if (data.hasPredictiveRelationship()) {
            return this.getTitleForPredictiveRelationship(data, locale);
        }
        return this.getTitleForNoPredictiveRelationship(data, locale);
    }

    private String getPredictiveStrengthTooltip(PredictiveStrengthResult.PredictiveStrengthData data, Locale locale) {
        if (data.hasPredictiveRelationship()) {
            return this.getMessageForPredictiveRelationship(data, locale);
        }
        return this.getMessageForNoPredictiveRelationship(data, locale);
    }

    private String getTitleForPredictiveRelationship(PredictiveStrengthResult.PredictiveStrengthData data, Locale locale) {
        List<String> factorNames = data.explanatoryNames;
        String targetName = data.targetName;
        String strengthPercentage = MessagesGeneratorCommon.formatAsPercentage(data.strength, locale);
        String strengthName = data.associationStrengthLevel.name();
        if (PredictiveStrengthDecoration.hasMultipleFactors(data)) {
            return this.getMessage("PREDICTIVE_STRENGTH_DECO_LONG_TWO_FACTOR_" + strengthName, locale, factorNames.get(0), factorNames.get(1), targetName, strengthPercentage);
        }
        return this.getMessage("PREDICTIVE_STRENGTH_DECO_LONG_SINGLE_FACTOR_" + strengthName, locale, factorNames.get(0), targetName, strengthPercentage);
    }

    private String getTitleForNoPredictiveRelationship(PredictiveStrengthResult.PredictiveStrengthData data, Locale locale) {
        List<String> factorNames = data.explanatoryNames;
        String targetName = data.targetName;
        if (PredictiveStrengthDecoration.hasMultipleFactors(data)) {
            return this.getMessage("PREDICTIVE_STRENGTH_DECO_LONG_TWO_FACTOR_NO_RELATIONSHIP", locale, factorNames.get(0), factorNames.get(1), targetName);
        }
        return this.getMessage("PREDICTIVE_STRENGTH_DECO_LONG_SINGLE_FACTOR_NO_RELATIONSHIP", locale, factorNames.get(0), targetName);
    }

    private String getMessageForPredictiveRelationship(PredictiveStrengthResult.PredictiveStrengthData data, Locale locale) {
        List<String> factorNames = data.explanatoryNames;
        String targetName = data.targetName;
        String strengthPercentage = MessagesGeneratorCommon.formatAsPercentage(data.strength, locale);
        String strengthName = data.associationStrengthLevel.name();
        if (PredictiveStrengthDecoration.hasMultipleFactors(data)) {
            return this.getMessage("PREDICTIVE_STRENGTH_DECO_LONG_TWO_FACTOR_" + strengthName, locale, factorNames.get(0), factorNames.get(1), targetName, strengthPercentage);
        }
        return this.getMessage("PREDICTIVE_STRENGTH_DECO_LONG_SINGLE_FACTOR_" + strengthName, locale, factorNames.get(0), targetName, strengthPercentage);
    }

    private String getMessageForNoPredictiveRelationship(PredictiveStrengthResult.PredictiveStrengthData data, Locale locale) {
        if (PredictiveStrengthDecoration.hasMultipleFactors(data)) {
            return this.getMessage("PREDICTIVE_STRENGTH_DECO_LONG_TWO_FACTOR_NO_RELATIONSHIP", locale, data.explanatoryNames.get(0), data.explanatoryNames.get(1), data.targetName);
        }
        return this.getMessage("PREDICTIVE_STRENGTH_DECO_LONG_SINGLE_FACTOR_NO_RELATIONSHIP", locale, data.explanatoryNames.get(0), data.targetName);
    }

    private String getMessage(String key, Locale locale, Object ... params) {
        return this.messages.getMessageBundle(BUNDLE_NAME, locale).getMessage(key, params);
    }

    private static boolean hasMultipleFactors(PredictiveStrengthResult.PredictiveStrengthData data) {
        return data.explanatoryNames.size() > 1;
    }

    private static void decorate(String key, Number value, Decorator decorator) {
        decorator.decorateGlobal(key, value);
    }

    private static void decorate(String key, String value, Decorator decorator) {
        decorator.decorateGlobal(key, value);
    }
}

