/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.annotation.decorations;

import com.ibm.bi.predict.algorithms.forecasting.result.ResultSorter;
import com.ibm.bi.predict.dataaccess.Decorator;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.sa.execution.annotation.DecorationStrategy;
import com.ibm.bi.predict.sa.execution.annotation.FieldRole;
import com.ibm.bi.predict.sa.execution.annotation.MessageService;
import com.ibm.bi.predict.sa.execution.annotation.result.AnnotationResult;
import com.ibm.bi.predict.sa.execution.annotation.result.TimeSeriesResult;
import com.ibm.bi.predict.sa.execution.api.MetaDataAdapter;
import com.ibm.bi.predict.sa.execution.api.SuggestedAnnotation;
import com.ibm.bi.predict.utils.Tuple3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.math.NumberUtils;

public class TimeSeriesDecoration
implements DecorationStrategy<List<TimeSeriesResult.TimeSeriesData>> {
    private static final String BUNDLE_NAME = "Predict_Smart_Annotations";
    private static int INITIAL_CATEGORY_ID_VALUE = 98543451;
    private static String ID_PREFIX = "__ibm_ba_forecast__";
    private final SuggestedAnnotation suggestion;
    private final MetaDataAdapter metadata;
    private final MessageService messages;
    private final Map<List<Integer>, Integer> dataCellIndices;
    private final Map<Integer, FieldRole> fieldRoles;
    private int category_id_prefix;

    public TimeSeriesDecoration(SuggestedAnnotation suggestion, MetaDataAdapter metadata, MessageService messageService, Map<List<Integer>, Integer> dataCellIndices) {
        this.suggestion = suggestion;
        this.metadata = metadata;
        this.messages = messageService;
        this.dataCellIndices = dataCellIndices;
        this.fieldRoles = this.getFieldRoles();
        this.category_id_prefix = INITIAL_CATEGORY_ID_VALUE;
    }

    @Override
    public void decorate(Decorator decorator, AnnotationResult<List<TimeSeriesResult.TimeSeriesData>> result, Locale locale) {
        this.decorateOrAddData(decorator, result, locale, false);
    }

    @Override
    public void addData(Decorator decorator, AnnotationResult<List<TimeSeriesResult.TimeSeriesData>> result, Locale locale) {
        this.decorateOrAddData(decorator, result, locale, true);
    }

    private void decorateOrAddData(Decorator decorator, AnnotationResult<List<TimeSeriesResult.TimeSeriesData>> result, Locale locale, boolean addData) {
        int multipleMeasuresIndex = this.metadata.multipleMeasuresIndex();
        String measureName = this.metadata.getResponseName();
        Optional<AggregationType> aggregationType = this.metadata.getAggregationTypeOfField(this.metadata.getResponseIndex());
        List orderedResults = ResultSorter.getOrderedResults((Collection)result.getResult(), d -> d.seriesResult.id());
        for (TimeSeriesResult.TimeSeriesData data : orderedResults) {
            List<TimeSeriesResult.ForecastedPoint> forecastedValues = data.forecastedPoints;
            Number[] values = new Number[this.metadata.fieldCount()];
            for (int f = 0; f < forecastedValues.size(); ++f) {
                int newRowIdx;
                TimeSeriesResult.ForecastedPoint point = forecastedValues.get(f);
                ArrayList<Tuple3<Integer, String, Object>> cellDecorations = new ArrayList<Tuple3<Integer, String, Object>>();
                ArrayList<Integer> intIndices = new ArrayList<Integer>();
                Integer groupCategoryIndex = null;
                block7: for (int fieldIndex = 0; fieldIndex < this.metadata.fieldCount(); ++fieldIndex) {
                    FieldRole role = this.fieldRoles.get(fieldIndex);
                    switch (role) {
                        case EXPLANATORY: {
                            int categoryIdx;
                            Optional<Integer> maybeCategoryIndex = this.getCategoryIndexByLabel(fieldIndex, point.label);
                            if (maybeCategoryIndex.isPresent()) {
                                categoryIdx = maybeCategoryIndex.get();
                            } else {
                                if (!addData) continue block7;
                                categoryIdx = this.metadata.getCountOfFieldCategories(fieldIndex);
                                this.addCategory(decorator, point, fieldIndex, categoryIdx);
                            }
                            values[fieldIndex] = categoryIdx;
                            intIndices.add(categoryIdx);
                            continue block7;
                        }
                        case RESPONSE: {
                            values[fieldIndex] = point.value;
                            this.handleResponse(cellDecorations, point, fieldIndex, addData);
                            continue block7;
                        }
                        case GROUP: {
                            groupCategoryIndex = Integer.parseInt(data.seriesId);
                            values[fieldIndex] = groupCategoryIndex;
                            if (multipleMeasuresIndex < 0) continue block7;
                            measureName = this.metadata.getCategoryNamesForField(fieldIndex, groupCategoryIndex).get(multipleMeasuresIndex);
                            aggregationType = this.metadata.getCategoryAggregationsForField(fieldIndex, groupCategoryIndex).get(multipleMeasuresIndex);
                            continue block7;
                        }
                        default: {
                            values[fieldIndex] = 0.0;
                        }
                    }
                }
                String aggregate = aggregationType.isPresent() ? aggregationType.get().toString() : "none";
                cellDecorations.add(Tuple3.of((Object)this.metadata.getResponseIndex(), (Object)"tooltip", (Object)this.tooltip(locale, point, measureName, aggregate)));
                if (groupCategoryIndex != null) {
                    intIndices.add(groupCategoryIndex);
                }
                boolean containsIndices = this.dataCellIndices.containsKey(intIndices);
                if (addData && !containsIndices) {
                    newRowIdx = decorator.addDataRow(values);
                    this.addAllDecorations(decorator, cellDecorations, newRowIdx);
                    continue;
                }
                if (addData || !containsIndices) continue;
                newRowIdx = this.dataCellIndices.get(intIndices);
                this.addAllDecorations(decorator, cellDecorations, newRowIdx);
            }
        }
    }

    private void addAllDecorations(Decorator decorator, List<Tuple3<Integer, String, Object>> cellDecorations, int responseIndex) {
        for (Tuple3<Integer, String, Object> decoration : cellDecorations) {
            this.decorateCell(responseIndex, decorator, decoration);
        }
    }

    private void addCategory(Decorator decorator, TimeSeriesResult.ForecastedPoint point, int fieldIndex, int categoryIdx) {
        String[] displayLabels = point.label.split("\\|");
        String[] uniqueIds = (String[])this.metadata.getFieldIds(fieldIndex).stream().map(id -> this.generateCategoryId((String)id, categoryIdx)).toArray(String[]::new);
        decorator.addCategory(fieldIndex, displayLabels, uniqueIds);
    }

    private void handleResponse(List<Tuple3<Integer, String, Object>> cellDecorations, TimeSeriesResult.ForecastedPoint point, int fieldIndex, boolean isForecast) {
        cellDecorations.add((Tuple3<Integer, String, Object>)Tuple3.of((Object)fieldIndex, (Object)"forecastHighConfidence", (Object)point.upperBound));
        cellDecorations.add((Tuple3<Integer, String, Object>)Tuple3.of((Object)fieldIndex, (Object)"forecastLowConfidence", (Object)point.lowerBound));
        cellDecorations.add((Tuple3<Integer, String, Object>)Tuple3.of((Object)fieldIndex, (Object)"forecast", (Object)isForecast));
        cellDecorations.add((Tuple3<Integer, String, Object>)Tuple3.of((Object)fieldIndex, (Object)"forecastValue", (Object)point.value));
    }

    public String generateCategoryId(String fieldId, int categoryIndex) {
        long initialBase = this.isNumeric(fieldId.substring(2)) ? Long.parseLong(fieldId.substring(2)) : (this.isNumeric(fieldId.substring(3)) ? Long.parseLong(fieldId.substring(3)) : (long)fieldId.hashCode());
        long id = initialBase + (long)categoryIndex;
        if (id < 0L || id > Integer.MAX_VALUE) {
            this.category_id_prefix += categoryIndex;
            id = this.category_id_prefix;
        }
        return ID_PREFIX + Integer.toString((int)id);
    }

    private boolean isNumeric(String field) {
        return NumberUtils.isNumber((String)field);
    }

    private Optional<Integer> getCategoryIndexByLabel(int fieldIdx, String categoryLabel) {
        for (int i = 0; i < this.metadata.getCountOfFieldCategories(fieldIdx); ++i) {
            if (!categoryLabel.equals(this.metadata.getCategoryNameForField(fieldIdx, i))) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    private Map<Integer, FieldRole> getFieldRoles() {
        return IntStream.range(0, this.metadata.fieldCount()).boxed().collect(Collectors.toMap(Function.identity(), this::getFieldRole));
    }

    private FieldRole getFieldRole(int index) {
        String identifier = this.metadata.getFieldId(index);
        if (identifier.contains(":")) {
            return FieldRole.NONE;
        }
        int dataItemIdx = this.suggestion.dataItems.indexOf(identifier);
        if (dataItemIdx < 0) {
            throw new IllegalArgumentException("Found no element with ID" + identifier);
        }
        return FieldRole.fromString(this.suggestion.roles.get(dataItemIdx));
    }

    private void decorateCell(int rowIdx, Decorator decorator, Tuple3<Integer, String, Object> decoration) {
        if (decoration._3 instanceof String[][]) {
            decorator.decorateCell(((Integer)decoration._1).intValue(), rowIdx, (String)decoration._2, (String[][])decoration._3);
        } else if (decoration._3 instanceof Number) {
            decorator.decorateCell(((Integer)decoration._1).intValue(), rowIdx, (String)decoration._2, (Number)decoration._3);
        } else if (decoration._3 instanceof Boolean) {
            decorator.decorateCell(((Integer)decoration._1).intValue(), rowIdx, (String)decoration._2, (Boolean)decoration._3);
        } else {
            throw new IllegalArgumentException("Invalid type for decoration");
        }
    }

    private String[][] tooltip(Locale locale, TimeSeriesResult.ForecastedPoint point, String measureName, String aggregate) {
        MessageService.MessageBundle msgBundle = this.messages.getMessageBundle(BUNDLE_NAME, locale);
        String aggregateName = msgBundle.getMessage(aggregate, new Object[0]);
        String valueKey = "TIME_SERIES_DECO_TOOLTIP_VALUE";
        return new String[][]{{msgBundle.getMessage("TIME_SERIES_DECO_TOOLTIP_UPPER_BOUND", new Object[0]), msgBundle.getMessage(valueKey, point.upperBound)}, {msgBundle.getMessage("TIME_SERIES_DECO_TOOLTIP_FORECAST", measureName, aggregateName), msgBundle.getMessage(valueKey, point.value)}, {msgBundle.getMessage("TIME_SERIES_DECO_TOOLTIP_LOWER_BOUND", new Object[0]), msgBundle.getMessage(valueKey, point.lowerBound)}};
    }
}

