/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.annotation.impl;

import com.ibm.bi.predict.dataaccess.Decorator;
import com.ibm.bi.predict.sa.execution.annotation.Annotation;
import com.ibm.bi.predict.sa.execution.annotation.ConditionalResponses;
import com.ibm.bi.predict.sa.execution.annotation.FieldRole;
import com.ibm.bi.predict.sa.execution.annotation.MessageServiceImpl;
import com.ibm.bi.predict.sa.execution.annotation.decorations.AverageDecoration;
import com.ibm.bi.predict.sa.execution.annotation.response.Conditional;
import com.ibm.bi.predict.sa.execution.annotation.response.ConditionalResponse;
import com.ibm.bi.predict.sa.execution.annotation.result.AnnotationResult;
import com.ibm.bi.predict.sa.execution.annotation.result.MeanResult;
import com.ibm.bi.predict.sa.execution.api.DataRowAdapter;
import com.ibm.bi.predict.sa.execution.api.MetaDataAdapter;
import com.ibm.bi.predict.sa.execution.api.SuggestedAnnotation;
import java.util.List;
import java.util.Locale;

public class MeanAnnotation
extends Annotation<MeanResult.MeanData>
implements Conditional {
    private static final int MIN_CATS = 2;
    private int count = 0;
    protected double mean = 0.0;

    public MeanAnnotation(MetaDataAdapter metadata) {
        super(metadata);
    }

    @Override
    public ConditionalResponse assertPreconditions() {
        List<Integer> explIndices = this.metadata.getFieldIndicesByRole(FieldRole.EXPLANATORY);
        if (explIndices.isEmpty()) {
            return ConditionalResponses.INVALID_FIELD_UNSPECIFIED();
        }
        int explIndex = explIndices.get(0);
        if (this.metadata.getCountOfFieldCategories(explIndex) < 2) {
            return ConditionalResponses.TOO_FEW_CATEGORIES(this.metadata.getNameOfField(explIndex));
        }
        return ConditionalResponses.SUCCESS;
    }

    @Override
    public void update(DataRowAdapter dataRow) {
        double value = dataRow.getTargetValue();
        ++this.count;
        this.mean += (value - this.mean) / (double)this.count;
    }

    @Override
    public ConditionalResponse postUpdate() {
        return ConditionalResponses.SUCCESS;
    }

    @Override
    public AnnotationResult<MeanResult.MeanData> buildResult() {
        return new MeanResult(new MeanResult.MeanData(this.mean, this.metadata.getResponseName()));
    }

    @Override
    public void decorate(Decorator decorator, SuggestedAnnotation annotationSuggestion, Locale locale) {
        AnnotationResult<MeanResult.MeanData> result = this.getResult();
        if (!result.isEmpty()) {
            new AverageDecoration(annotationSuggestion.indexOfTarget, new MessageServiceImpl()).decorate(decorator, result, locale);
        }
    }
}

