/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.annotation.impl;

import com.ibm.bi.predict.algorithms.table.results.InfluentialCategory;
import com.ibm.bi.predict.data.matrix.Matrix;
import com.ibm.bi.predict.data.matrix.MatrixVectorFactory;
import com.ibm.bi.predict.dataaccess.Decorator;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.sa.execution.annotation.ConditionalResponses;
import com.ibm.bi.predict.sa.execution.annotation.DataRowValidator;
import com.ibm.bi.predict.sa.execution.annotation.MessageServiceImpl;
import com.ibm.bi.predict.sa.execution.annotation.decorations.MeaningfulDifferencesDecoration;
import com.ibm.bi.predict.sa.execution.annotation.impl.AnnotationImpl;
import com.ibm.bi.predict.sa.execution.annotation.impl.math.ChiSquare;
import com.ibm.bi.predict.sa.execution.annotation.impl.math.MeaningfulDifferences;
import com.ibm.bi.predict.sa.execution.annotation.impl.math.StatisticsMap;
import com.ibm.bi.predict.sa.execution.annotation.impl.types.CategoryName;
import com.ibm.bi.predict.sa.execution.annotation.response.ConditionalResponse;
import com.ibm.bi.predict.sa.execution.annotation.result.AnnotationResult;
import com.ibm.bi.predict.sa.execution.annotation.result.EmptyResult;
import com.ibm.bi.predict.sa.execution.annotation.result.MeaningfulDifferencesResult;
import com.ibm.bi.predict.sa.execution.api.DataRowAdapter;
import com.ibm.bi.predict.sa.execution.api.MetaDataAdapter;
import com.ibm.bi.predict.sa.execution.api.SuggestedAnnotation;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;

public class OneWayChiSquareAnnotation
extends AnnotationImpl<List<MeaningfulDifferencesResult.MeaningfulDifferencesData>>
implements DataRowValidator {
    private static final Logger log = PredictLoggerFactory.getLogger(OneWayChiSquareAnnotation.class);
    private Matrix values;
    private Matrix indices;
    private AggregationType aggregationType;
    private List<InfluentialCategory> outliers;
    private StatisticsMap statistics = new StatisticsMap();
    private int numOfCategories = 0;

    public OneWayChiSquareAnnotation(MetaDataAdapter metaData) {
        super(metaData);
        this.values = MatrixVectorFactory.makeMatrix((int)this.metadata.factorACount(), (int)this.metadata.factorBCount(), (int)this.metadata.rowCount());
        this.indices = MatrixVectorFactory.makeMatrix((int)this.metadata.factorACount(), (int)this.metadata.factorBCount(), (int)this.metadata.rowCount());
        this.aggregationType = this.getResponseAggregation();
        if (this.aggregationType == AggregationType.SUM) {
            this.statistics.addStatistic(StatisticsMap.StatisticName.ROW_COUNT, MatrixVectorFactory.makeMatrix((int)this.metadata.factorACount(), (int)this.metadata.factorBCount(), (int)this.metadata.rowCount()));
            this.statistics.addStatistic(StatisticsMap.StatisticName.SUM_OF_SQUARES, MatrixVectorFactory.makeMatrix((int)this.metadata.factorACount(), (int)this.metadata.factorBCount(), (int)this.metadata.rowCount()));
        }
    }

    @Override
    public ConditionalResponse assertPreconditions() {
        int numberOfCategories = this.metadata.getCountOfExplanatoryFieldCategories(0);
        if (numberOfCategories < 3) {
            return ConditionalResponses.TOO_FEW_CATEGORIES(this.metadata.getNameOfExplanatoryField(0));
        }
        return ConditionalResponses.SUCCESS;
    }

    @Override
    public void update(DataRowAdapter dataRow) {
        double responseValue = dataRow.getTargetValue();
        int factorIndex = (int)dataRow.getExplanatoryValue();
        this.values.setValue(0, factorIndex, responseValue);
        this.indices.setValue(0, factorIndex, (double)dataRow.getDataRowIndex());
        ++this.numOfCategories;
        if (this.aggregationType == AggregationType.SUM) {
            int row = 0;
            int col = (int)dataRow.getExplanatoryValue();
            this.statistics.updateStatistic(StatisticsMap.StatisticName.ROW_COUNT, row, col, dataRow.getTargetStatistic(StatisticsMap.StatisticName.ROW_COUNT));
            this.statistics.updateStatistic(StatisticsMap.StatisticName.SUM_OF_SQUARES, row, col, dataRow.getTargetStatistic(StatisticsMap.StatisticName.SUM_OF_SQUARES));
        }
    }

    @Override
    public ConditionalResponse postUpdate() {
        log.perfStart();
        this.outliers = this.aggregationType == AggregationType.SUM ? this.outliersForSumAggregation() : this.outliersForCountAggregation();
        log.perfLog("Completed one-way chi square - numOutliers={}", (Object)this.outliers.size());
        log.perfStop();
        return ConditionalResponses.SUCCESS;
    }

    @Override
    public AnnotationResult<List<MeaningfulDifferencesResult.MeaningfulDifferencesData>> buildResult() {
        if (this.outliers.isEmpty()) {
            return new EmptyResult<List<MeaningfulDifferencesResult.MeaningfulDifferencesData>>();
        }
        List<MeaningfulDifferencesResult.MeaningfulDifferencesData> annotations = this.outliers.stream().map(outlier -> {
            int indexOfOutlierCategory = (Integer)outlier.categoryIndex._2;
            String outlierCategoryName = this.metadata.getCategoryNameOfExplanatoryField(0, indexOfOutlierCategory);
            return new MeaningfulDifferencesResult.MeaningfulDifferencesData((int)this.indices.getValue(((Integer)outlier.categoryIndex._1).intValue(), ((Integer)outlier.categoryIndex._2).intValue()), outlier.direction.toString().toLowerCase(), outlier.expected, outlier.pValue, CategoryName.fromString(outlierCategoryName), this.metadata.getResponseName(), Arrays.asList(this.metadata.getNameOfExplanatoryField(0)), Optional.of(this.aggregationType));
        }).collect(Collectors.toList());
        return new MeaningfulDifferencesResult(annotations);
    }

    @Override
    public void decorate(Decorator decorator, SuggestedAnnotation annotationSuggestion, Locale locale) {
        AnnotationResult<List<MeaningfulDifferencesResult.MeaningfulDifferencesData>> result = this.getResult();
        if (result != null && !result.isEmpty()) {
            new MeaningfulDifferencesDecoration(this.metadata.getResponseIndex(), new MessageServiceImpl()).decorate(decorator, result, locale);
        }
    }

    @Override
    public ConditionalResponse validateDataRow(DataRowAdapter dataRow) {
        return ConditionalResponses.SUCCESS;
    }

    private AggregationType getResponseAggregation() {
        return this.metadata.getAggregationTypeOfField(this.metadata.getResponseIndex()).orElseThrow(() -> new IllegalArgumentException("Expected field to have aggregation"));
    }

    private List<InfluentialCategory> outliersForSumAggregation() {
        return MeaningfulDifferences.detect(this.values, AggregationType.SUM, this.numOfCategories, this.statistics);
    }

    private List<InfluentialCategory> outliersForCountAggregation() {
        ChiSquare chiSquareTest = new ChiSquare(this.aggregationType, this.values);
        chiSquareTest.compute();
        return chiSquareTest.getOutliers();
    }
}

