/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.annotation.impl.math;

import com.ibm.bi.predict.algorithms.table.ChiSquareForSum;
import com.ibm.bi.predict.algorithms.table.results.InfluentialCategory;
import com.ibm.bi.predict.data.matrix.Matrix;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.sa.execution.annotation.impl.math.ChiSquare;
import com.ibm.bi.predict.sa.execution.annotation.impl.math.StatisticsMap;
import java.util.List;

public class MeaningfulDifferences {
    private MeaningfulDifferences() {
    }

    public static List<InfluentialCategory> detect(Matrix values, AggregationType aggregationType, int numberOfCategories, StatisticsMap statMap) {
        return MeaningfulDifferences.detectBasedOnAggregation(values, aggregationType, numberOfCategories, statMap);
    }

    private static List<InfluentialCategory> detectBasedOnAggregation(Matrix values, AggregationType aggregationType, int numberOfCategories, StatisticsMap statMap) {
        if (aggregationType == AggregationType.COUNT) {
            return MeaningfulDifferences.meaningfulDifferencesForCount(values, statMap);
        }
        if (aggregationType == AggregationType.SUM) {
            return MeaningfulDifferences.meaningfulDifferencesForSum(values, numberOfCategories, statMap);
        }
        return MeaningfulDifferences.meaningfulDifferencesForOther(values, aggregationType, statMap);
    }

    private static List<InfluentialCategory> meaningfulDifferencesForCount(Matrix values, StatisticsMap statMap) {
        ChiSquare chiSquareTest = new ChiSquare(AggregationType.COUNT, values);
        chiSquareTest.compute();
        return chiSquareTest.getOutliers();
    }

    private static List<InfluentialCategory> meaningfulDifferencesForSum(Matrix values, int numberOfCategories, StatisticsMap statMap) {
        Matrix counts = statMap.getStatistic(StatisticsMap.StatisticName.ROW_COUNT).get();
        Matrix sumOfSquares = statMap.getStatistic(StatisticsMap.StatisticName.SUM_OF_SQUARES).get();
        return new ChiSquareForSum(values, counts, sumOfSquares, numberOfCategories).compute();
    }

    private static List<InfluentialCategory> meaningfulDifferencesForOther(Matrix values, AggregationType aggregationType, StatisticsMap statMap) {
        ChiSquare chiSquareTest = new ChiSquare(aggregationType, values);
        chiSquareTest.compute();
        return chiSquareTest.getOutliers();
    }
}

