/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.annotation.impl.types;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class CategoryName {
    private final List<String> names = new ArrayList<String>();

    public static CategoryName fromString(String categoryName) {
        return new CategoryName(categoryName);
    }

    public static List<CategoryName> fromList(List<String> catNames) {
        return catNames.stream().map(CategoryName::fromString).collect(Collectors.toList());
    }

    public static CategoryName compound(String ... categoryNames) {
        return new CategoryName(Lists.newArrayList((Object[])categoryNames));
    }

    public CategoryName(String categoryName) {
        this.names.add(categoryName);
    }

    public CategoryName(List<String> categoryNames) {
        this.names.addAll(categoryNames);
    }

    public boolean isCompound() {
        return this.names.size() > 1;
    }

    public String categoryName() {
        return this.names.get(0);
    }

    public List<String> categoryNames() {
        return this.names;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.names).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CategoryName)) {
            return false;
        }
        CategoryName other = (CategoryName)CategoryName.class.cast(obj);
        return new EqualsBuilder().append(this.names, other.names).isEquals();
    }

    public String toString() {
        return String.join((CharSequence)" | ", this.names);
    }
}

