/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.annotation.response;

import com.ibm.bi.predict.algorithms.forecasting.exception.ForecastingParametersException;
import com.ibm.bi.predict.algorithms.forecasting.result.ForecastingResult;
import com.ibm.bi.predict.algorithms.forecasting.result.ForecastingResultData;
import com.ibm.bi.predict.algorithms.forecasting.time.TimeDelta;
import com.ibm.bi.predict.algorithms.forecasting.time.TimeUnit;
import com.ibm.bi.predict.result.ExecutionResult;
import com.ibm.bi.predict.result.MessageCode;
import com.ibm.bi.predict.sa.execution.annotation.response.ConditionalResponse;
import com.ibm.bi.predict.sa.execution.annotation.response.ConditionalResponseConstants;
import com.ibm.bi.predict.sa.execution.annotation.response.FailedAnnotationResponse;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class ExecutionResultToConditionalResponses {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(ExecutionResultToConditionalResponses.class);

    private ExecutionResultToConditionalResponses() {
    }

    public static Set<ConditionalResponse> convertResult(ExecutionResult<?> result) {
        HashSet<ConditionalResponse> set = new HashSet<ConditionalResponse>();
        result.getWarningMessages().stream().map(m -> ExecutionResultToConditionalResponses.fromMessage(result, m.getMessageCode())).filter(Optional::isPresent).forEach(o -> set.add((ConditionalResponse)o.get()));
        result.getErrorMessages().stream().map(m -> ExecutionResultToConditionalResponses.fromMessage(result, m.getMessageCode())).filter(Optional::isPresent).forEach(o -> set.add((ConditionalResponse)o.get()));
        return set;
    }

    private static Optional<ConditionalResponse> fromMessage(ExecutionResult<?> result, MessageCode m) {
        if (m == MessageCode.FORECASTING_MISSING_EXCEEDS_THRESHOLD) {
            return Optional.of(ExecutionResultToConditionalResponses.getForecastingMissingResponse(result));
        }
        if (m == MessageCode.FORECASTING_TOO_FEW_POINTS) {
            return Optional.of(new ConditionalResponse(Arrays.asList(FailedAnnotationResponse.withoutParameters(ConditionalResponse.FailureType.KEY_WARN, ConditionalResponseConstants.RESPONSE_FORECAST_TOO_FEW_POINTS.id(), ConditionalResponseConstants.ACTION_FORECAST_TOO_FEW_POINTS.id()))));
        }
        if (m == MessageCode.FORECASTING_MISSING_BELOW_THRESHOLD) {
            return Optional.of(new ConditionalResponse(Arrays.asList(FailedAnnotationResponse.withoutParameters(ConditionalResponse.FailureType.KEY_WARN, ConditionalResponseConstants.RESPONSE_MISSING_BELOW_THRESHOLD.id(), ConditionalResponseConstants.ACTION_MISSING_BELOW_THRESHOLD.id()))));
        }
        if (m == MessageCode.FORECASTING_INVALID_TIME_CATEGORIES) {
            return Optional.of(new ConditionalResponse(Arrays.asList(FailedAnnotationResponse.withoutParameters(ConditionalResponse.FailureType.KEY_WARN, ConditionalResponseConstants.RESPONSE_INVALID_TIME_CATEGORIES.id(), ConditionalResponseConstants.ACTION_INVALID_TIME_CATEGORIES.id()))));
        }
        return Optional.empty();
    }

    private static ConditionalResponse getForecastingMissingResponse(ExecutionResult<?> result) {
        TimeDelta d;
        ForecastingResult r;
        if (result instanceof ForecastingResult && ((ForecastingResultData)(r = (ForecastingResult)result).getContent()).getTimeDelta() != null && (d = ((ForecastingResultData)r.getContent()).getTimeDelta()).getUnit() != TimeUnit.UNKNOWN && d.getSteps() >= 1L) {
            String infix = d.getSteps() == 1L ? "_SINGULAR_" : "_PLURAL_";
            FailedAnnotationResponse resp = FailedAnnotationResponse.withErrorMessageParameters(ConditionalResponse.FailureType.KEY_WARN, ConditionalResponseConstants.RESPONSE_MISSING_EXCEEDS_THRESHOLD.id(), ConditionalResponseConstants.ACTION_MISSING_EXCEEDS_THRESHOLD.id() + infix + d.getUnit().toString().toUpperCase(), Long.toString(d.getSteps()));
            return new ConditionalResponse(Arrays.asList(resp));
        }
        LOGGER.debug("Received result without usable time delta");
        return new ConditionalResponse(Arrays.asList(FailedAnnotationResponse.withoutParameters(ConditionalResponse.FailureType.KEY_WARN, ConditionalResponseConstants.RESPONSE_MISSING_EXCEEDS_THRESHOLD.id(), ConditionalResponseConstants.ACTION_MISSING_EXCEEDS_THRESHOLD.id())));
    }

    public static Set<ConditionalResponse> convertException(Exception exception) {
        if (exception instanceof ForecastingParametersException) {
            return Collections.singleton(ExecutionResultToConditionalResponses.fromForecastingParametersException((ForecastingParametersException)exception));
        }
        return Collections.emptySet();
    }

    private static ConditionalResponse fromForecastingParametersException(ForecastingParametersException exception) {
        String messageKey = "FORECAST_EXCEPTION_" + exception.getParameter();
        return new ConditionalResponse(Arrays.asList(FailedAnnotationResponse.withoutParameters(ConditionalResponse.FailureType.KEY_ERROR, messageKey, "ACTION_" + messageKey)));
    }
}

