/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.annotation.result;

import com.ibm.bi.predict.algorithms.ThreeLevelScale;
import com.ibm.bi.predict.sa.execution.annotation.impl.types.LineEquation;
import com.ibm.bi.predict.sa.execution.annotation.result.AnnotationResult;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class FitLineResult
implements AnnotationResult<List<FitLineData>> {
    private List<FitLineData> data;

    public FitLineResult(List<FitLineData> data) {
        this.data = data;
    }

    @Override
    public List<FitLineData> getResult() {
        return this.data;
    }

    public static class FitLineData {
        public final double[] coefficients;
        public final LineEquation equation;
        public final double adjustedRSquared;
        public final String categoryName;
        public final String categoryIdentifier;
        public final String groupName;
        public final ThreeLevelScale strength;
        public final String responseName;
        public final String explanatoryName;

        public FitLineData(double[] coefficients, LineEquation equation, double adjustedRSquared, ThreeLevelScale strength, String responseName, String explanatoryName) {
            this(coefficients, equation, adjustedRSquared, null, null, null, strength, responseName, explanatoryName);
        }

        public FitLineData(double[] coefficients, LineEquation equation, double adjustedRSquared, String categoryName, String categoryIdentifier, String groupName, ThreeLevelScale strength, String responseName, String explanatoryName) {
            this.coefficients = coefficients;
            this.equation = equation;
            this.adjustedRSquared = adjustedRSquared;
            this.categoryName = categoryName;
            this.categoryIdentifier = categoryIdentifier;
            this.groupName = groupName;
            this.strength = strength;
            this.responseName = responseName;
            this.explanatoryName = explanatoryName;
        }

        public String toString() {
            return String.format("[coefficients: %s, equation: %s, adjustedRSquared: %f, categoryName: %s, categoryIdentifier: %s, groupName: %s, strength: %s, responseName: %s, explanatoryName: %s]", Arrays.toString(this.coefficients), this.equation.getEquation(Locale.getDefault()), this.adjustedRSquared, this.categoryName, this.categoryIdentifier, this.groupName, this.strength, this.responseName, this.explanatoryName);
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.coefficients).append((Object)this.equation).append(this.adjustedRSquared).append((Object)this.categoryName).append((Object)this.categoryIdentifier).append((Object)this.groupName).append((Object)this.strength).append((Object)this.responseName).append((Object)this.explanatoryName).toHashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FitLineData)) {
                return false;
            }
            FitLineData other = (FitLineData)FitLineData.class.cast(obj);
            return new EqualsBuilder().append(this.coefficients, other.coefficients).append((Object)this.equation, (Object)other.equation).append(this.adjustedRSquared, other.adjustedRSquared).append((Object)this.categoryName, (Object)other.categoryName).append((Object)this.categoryIdentifier, (Object)other.categoryIdentifier).append((Object)this.groupName, (Object)other.groupName).append((Object)this.strength, (Object)other.strength).append((Object)this.responseName, (Object)other.responseName).append((Object)this.explanatoryName, (Object)other.explanatoryName).isEquals();
        }
    }
}

