/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.annotation.result;

import com.ibm.bi.predict.sa.execution.annotation.result.AnnotationResult;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ModeResult
implements AnnotationResult<ModeData> {
    private ModeData result;

    public ModeResult(ModeData result) {
        this.result = result;
    }

    @Override
    public ModeData getResult() {
        return this.result;
    }

    public static class ModeData {
        private final String explanatoryName;
        private final int modeCount;
        private final double modePercent;
        private final List<String> categoryLabels;
        private final boolean allSame;

        public ModeData(String explanatoryName, int modeCount, double modePercent, List<String> categoryLabels, boolean allSame) {
            this.modePercent = modePercent;
            this.modeCount = modeCount;
            this.explanatoryName = explanatoryName;
            this.categoryLabels = categoryLabels;
            this.allSame = allSame;
        }

        public static ModeData noResult(String explanatoryName) {
            return new ModeData(explanatoryName, 0, 0.0, Collections.emptyList(), false);
        }

        public String getExplanatoryName() {
            return this.explanatoryName;
        }

        public int getModeCount() {
            return this.modeCount;
        }

        public double getModePercent() {
            return this.modePercent;
        }

        public List<String> getCategoryLabels() {
            return this.categoryLabels;
        }

        public boolean allSame() {
            return this.allSame;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.explanatoryName).append(this.modeCount).append(this.modePercent).append((Object)Objects.toString(this.categoryLabels)).append(this.allSame).toHashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ModeData)) {
                return false;
            }
            ModeData other = (ModeData)ModeData.class.cast(obj);
            return new EqualsBuilder().append((Object)this.explanatoryName, (Object)other.explanatoryName).append(this.modeCount, other.modeCount).append(this.modePercent, other.modePercent).append((Object)Objects.toString(this.categoryLabels), (Object)Objects.toString(other.categoryLabels)).append(this.allSame, other.allSame).isEquals();
        }

        public String toString() {
            return String.format("[ count: %d, percent: %f, explanatoryName: %s, categories: %s, allSame %s ]", this.modeCount, this.modePercent, this.explanatoryName, Objects.toString(this.categoryLabels), Objects.toString(this.allSame));
        }
    }
}

