/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.annotation.result;

import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.sa.execution.annotation.result.AnnotationResult;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class OutlierResult
implements AnnotationResult<List<OutlierData>> {
    private List<OutlierData> result;

    public OutlierResult(List<OutlierData> result) {
        this.result = result;
    }

    @Override
    public List<OutlierData> getResult() {
        return this.result;
    }

    public static class OutlierData
    implements Comparable<OutlierData> {
        public final int cellIdx;
        public final String outlierType;
        public final double outlierMeasureValue;
        public final double responseValue;
        public final double explanatoryValue;
        public final String responseName;
        public final String explanatoryName;
        public final Optional<AggregationType> responseAggregationType;

        public OutlierData(int cellIdx, String outlierType, double outlierMeasureValue, double responseValue, double explanatoryValue, String responseName, String explanatoryName) {
            this(cellIdx, outlierType, outlierMeasureValue, responseValue, explanatoryValue, responseName, explanatoryName, Optional.empty());
        }

        public OutlierData(int cellIdx, String outlierType, double outlierMeasureValue, double responseValue, double explanatoryValue, String responseName, String explanatoryName, Optional<AggregationType> responseAggregationType) {
            this.cellIdx = cellIdx;
            this.outlierType = outlierType;
            this.outlierMeasureValue = outlierMeasureValue;
            this.responseValue = responseValue;
            this.explanatoryValue = explanatoryValue;
            this.responseName = responseName;
            this.explanatoryName = explanatoryName;
            this.responseAggregationType = responseAggregationType;
        }

        public double getResponseValue() {
            return this.responseValue;
        }

        public double getOutlierMeasureValue() {
            return this.outlierMeasureValue;
        }

        @Override
        public int compareTo(OutlierData data) {
            int compareMeasureValue = Double.compare(Math.abs(data.getOutlierMeasureValue()), Math.abs(this.getOutlierMeasureValue()));
            if (compareMeasureValue == 0) {
                return Double.compare(data.getResponseValue(), this.getResponseValue());
            }
            return compareMeasureValue;
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.cellIdx).append((Object)this.outlierType).append(this.outlierMeasureValue).append(this.responseValue).append(this.explanatoryValue).append((Object)this.responseName).append((Object)this.explanatoryName).toHashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OutlierData)) {
                return false;
            }
            OutlierData other = (OutlierData)OutlierData.class.cast(obj);
            return new EqualsBuilder().append(this.cellIdx, other.cellIdx).append((Object)this.outlierType, (Object)other.outlierType).append(this.outlierMeasureValue, other.outlierMeasureValue).append(this.responseValue, other.responseValue).append(this.explanatoryValue, other.explanatoryValue).append((Object)this.responseName, (Object)other.responseName).append((Object)this.explanatoryName, (Object)other.explanatoryName).append(this.responseAggregationType, other.responseAggregationType).isEquals();
        }

        public String toString() {
            return String.format("[cellIdx: %d, outlierType: %s, measureValue: %f, responseValue: %f, explanatoryValue: %f, responseName: %s, explanatoryName: %s, responseAggregationType: %s ]", this.cellIdx, this.outlierType, this.outlierMeasureValue, this.responseValue, this.explanatoryValue, this.responseName, this.explanatoryName, this.responseAggregationType);
        }
    }
}

