/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.annotation.result;

import com.ibm.bi.predict.algorithms.ThreeLevelScale;
import com.ibm.bi.predict.sa.execution.annotation.result.AnnotationResult;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class PredictiveStrengthResult
implements AnnotationResult<PredictiveStrengthData> {
    private PredictiveStrengthData result;

    public PredictiveStrengthResult(PredictiveStrengthData result) {
        this.result = result;
    }

    @Override
    public PredictiveStrengthData getResult() {
        return this.result;
    }

    public static PredictiveStrengthResult noRelationshipResult(double pValue, double effectSize, String targetName, List<String> explanatoryNames) {
        return new PredictiveStrengthResult(new PredictiveStrengthData(pValue, effectSize, 0.0, null, targetName, explanatoryNames));
    }

    public static class PredictiveStrengthData {
        public final double pValue;
        public final double effectSize;
        public final double strength;
        public final ThreeLevelScale associationStrengthLevel;
        public final String targetName;
        public final List<String> explanatoryNames;

        public PredictiveStrengthData(double pValue, double effectSize, double strength, ThreeLevelScale level, String targetName, String explanatoryName) {
            this(pValue, effectSize, strength, level, targetName, Arrays.asList(explanatoryName));
        }

        public PredictiveStrengthData(double pValue, double effectSize, double strength, ThreeLevelScale level, String targetName, List<String> explanatoryNames) {
            this.pValue = pValue;
            this.effectSize = effectSize;
            this.strength = strength;
            this.associationStrengthLevel = level;
            this.targetName = targetName;
            this.explanatoryNames = explanatoryNames;
        }

        public boolean hasPredictiveRelationship() {
            return this.associationStrengthLevel != null;
        }

        public String toString() {
            return String.format("[ pValue: %f, effectSize: %f, strengthLevel: %s, adjustedRSquared: %f ]", this.pValue, this.effectSize, this.associationStrengthLevel, this.strength);
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.pValue).append(this.effectSize).append(this.strength).append((Object)this.associationStrengthLevel).append((Object)this.targetName).append(this.explanatoryNames).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof PredictiveStrengthData) {
                PredictiveStrengthData other = (PredictiveStrengthData)obj;
                return new EqualsBuilder().append(this.pValue, other.pValue).append(this.effectSize, other.effectSize).append(this.strength, other.strength).append((Object)this.associationStrengthLevel, (Object)other.associationStrengthLevel).append((Object)this.targetName, (Object)other.targetName).append(this.explanatoryNames, other.explanatoryNames).isEquals();
            }
            return false;
        }
    }
}

