/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.annotation.result;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.ibm.bi.predict.sa.execution.annotation.response.ConditionalResponse;
import com.ibm.bi.predict.sa.execution.annotation.result.AnnotationResult;
import com.ibm.bi.predict.sa.execution.annotation.result.ExecutionResult;
import com.ibm.bi.predict.sa.execution.api.Diagnostics;
import com.ibm.bi.predict.sa.execution.api.SuggestedAnnotation;
import com.ibm.bi.predict.utils.Tuple;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.json.JSONObject;

public class ResultsConsolidator {
    public ExecutionResult consolidateExecutionResults(List<ExecutionResult> executionResults) {
        return new ExecutionResult(this.consolidateIssues(executionResults), ResultsConsolidator.consolidateResults(executionResults), ResultsConsolidator.consolidateOriginalRequests(executionResults), ResultsConsolidator.consolidateDiagnostics(executionResults), this.consolidateIsReordered(executionResults));
    }

    private boolean consolidateIsReordered(List<ExecutionResult> executionResults) {
        return executionResults.stream().anyMatch(r -> r.isReordered());
    }

    private Map<SuggestedAnnotation, Set<ConditionalResponse>> consolidateIssues(List<ExecutionResult> executionResults) {
        return executionResults.stream().flatMap(er -> er.getExecutionIssues().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static ListMultimap<SuggestedAnnotation, AnnotationResult<?>> consolidateResults(List<ExecutionResult> executionResults) {
        ArrayListMultimap results = ArrayListMultimap.create();
        executionResults.forEach(arg_0 -> ResultsConsolidator.lambda$consolidateResults$3((ListMultimap)results, arg_0));
        return results;
    }

    private static JSONObject consolidateOriginalRequests(List<ExecutionResult> executionResults) {
        return executionResults.isEmpty() ? new JSONObject() : executionResults.get((int)0).originalRequest;
    }

    private static Diagnostics consolidateDiagnostics(List<ExecutionResult> executionResults) {
        long overallTime = executionResults.stream().map(ExecutionResult::getDiagnostics).mapToLong(d -> d.getOverall()).sum();
        HashMap<String, List<Tuple<String, Double>>> inputConcepts = executionResults.size() > 0 ? executionResults.get(0).getDiagnostics().getInputConcepts() : new HashMap<String, List<Tuple<String, Double>>>();
        return new Diagnostics(overallTime, inputConcepts);
    }

    private static /* synthetic */ void lambda$consolidateResults$3(ListMultimap results, ExecutionResult er) {
        ListMultimap<SuggestedAnnotation, AnnotationResult<?>> result = er.getResults();
        result.entries().stream().forEach(entry -> results.put(entry.getKey(), entry.getValue()));
    }
}

