/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.annotation.result;

import com.ibm.bi.predict.algorithms.StatisticalDetails;
import com.ibm.bi.predict.algorithms.forecasting.result.SeriesResult;
import com.ibm.bi.predict.sa.execution.annotation.result.AnnotationResult;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class TimeSeriesResult
implements AnnotationResult<List<TimeSeriesData>> {
    private List<TimeSeriesData> data;

    public TimeSeriesResult(List<TimeSeriesData> data) {
        this.data = data;
    }

    @Override
    public List<StatisticalDetails> getStatisticalDetails() {
        return this.data.stream().map(TimeSeriesData::getStatisticalDetails).collect(Collectors.toList());
    }

    @Override
    public List<TimeSeriesData> getResult() {
        return this.data;
    }

    public static class ForecastedPoint {
        public final double value;
        public final double upperBound;
        public final double lowerBound;
        public final String label;

        public ForecastedPoint(double value, double upperBound, double lowerBound, String label) {
            this.value = value;
            this.label = label;
            this.upperBound = upperBound;
            this.lowerBound = lowerBound;
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.value).append(this.upperBound).append(this.lowerBound).append((Object)this.label).toHashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ForecastedPoint)) {
                return false;
            }
            ForecastedPoint other = (ForecastedPoint)obj;
            return new EqualsBuilder().append(this.value, other.value).append(this.upperBound, other.upperBound).append(this.lowerBound, other.lowerBound).append((Object)this.label, (Object)other.label).isEquals();
        }
    }

    public static class TimeSeriesData {
        public final String seriesId;
        public final String seriesLabel;
        public final List<ForecastedPoint> forecastedPoints;
        public final StatisticalDetails statisticalDetails;
        public final SeriesResult seriesResult;

        public TimeSeriesData(SeriesResult seriesResult, List<ForecastedPoint> forecastedPoints) {
            this.seriesId = seriesResult.id();
            this.seriesLabel = seriesResult.getLabel();
            this.forecastedPoints = forecastedPoints;
            this.statisticalDetails = seriesResult.getStatisticalDetails();
            this.seriesResult = seriesResult;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.seriesId).append((Object)this.seriesLabel).append(this.forecastedPoints).toHashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TimeSeriesData)) {
                return false;
            }
            TimeSeriesData other = (TimeSeriesData)obj;
            return new EqualsBuilder().append((Object)this.seriesId, (Object)other.seriesId).append((Object)this.seriesLabel, (Object)other.seriesLabel).append(this.forecastedPoints, other.forecastedPoints).isEquals();
        }

        public StatisticalDetails getStatisticalDetails() {
            return this.statisticalDetails;
        }
    }
}

