/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.api;

import com.google.common.collect.Sets;
import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.DataIterator;
import com.ibm.bi.predict.dataaccess.DataRow;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.sa.execution.annotation.Annotation;
import com.ibm.bi.predict.sa.execution.annotation.ConditionalResponses;
import com.ibm.bi.predict.sa.execution.annotation.DataRowValidator;
import com.ibm.bi.predict.sa.execution.annotation.impl.FullDataAnnotation;
import com.ibm.bi.predict.sa.execution.annotation.response.ConditionalResponse;
import com.ibm.bi.predict.sa.execution.api.DataRowAdapter;
import com.ibm.bi.predict.sa.execution.api.ExecutionServiceImpl;
import com.ibm.bi.predict.sa.execution.api.SuggestedAnnotation;
import com.ibm.bi.predict.sa.execution.utils.Either;
import com.ibm.bi.predict.service.PredictServiceRequest;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class AnnotationExecutor {
    private static final Logger log = PredictLoggerFactory.getLogger(AnnotationExecutor.class);

    public Map<SuggestedAnnotation, Set<ConditionalResponse>> execute(Map<SuggestedAnnotation, Annotation<?>> annotations, PredictServiceRequest request) {
        log.perfStart();
        log.debug("Executing suggested annotations for {}", annotations.keySet());
        DataAccessProvider dataAccessProvider = request.getData().asDataAccessProvider();
        Map<SuggestedAnnotation, FullDataAnnotation<?>> fullDataAnnotations = annotations.entrySet().stream().filter(entry -> entry.getValue() instanceof FullDataAnnotation).collect(Collectors.toMap(Map.Entry::getKey, entry -> (FullDataAnnotation)entry.getValue()));
        Map<SuggestedAnnotation, Annotation<?>> updateAnnotations = annotations.entrySet().stream().filter(entry -> !(entry.getValue() instanceof FullDataAnnotation)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        HashMap<SuggestedAnnotation, Set<ConditionalResponse>> issues = new HashMap<SuggestedAnnotation, Set<ConditionalResponse>>();
        issues.putAll(this.runUpdate(updateAnnotations, dataAccessProvider));
        issues.putAll(this.runFullData(fullDataAnnotations, dataAccessProvider, request.getLocale()));
        Set<SuggestedAnnotation> errorAnnotations = ExecutionServiceImpl.getAnnotationsEndingInError(issues);
        errorAnnotations.forEach(eA -> annotations.keySet().remove(eA));
        issues.putAll(this.postUpdateAndBuildResult(annotations));
        return issues;
    }

    public Map<SuggestedAnnotation, Set<ConditionalResponse>> runFullData(Map<SuggestedAnnotation, FullDataAnnotation<?>> annotations, DataAccessProvider dataAccessProvider, Locale locale) {
        HashMap<SuggestedAnnotation, Set<ConditionalResponse>> issues = new HashMap<SuggestedAnnotation, Set<ConditionalResponse>>();
        annotations.entrySet().stream().forEach(a -> {
            FullDataAnnotation annotation = (FullDataAnnotation)a.getValue();
            SuggestedAnnotation suggestion = (SuggestedAnnotation)a.getKey();
            issues.put(suggestion, annotation.computeResult(dataAccessProvider, locale));
        });
        return issues;
    }

    public Map<SuggestedAnnotation, Set<ConditionalResponse>> runUpdate(Map<SuggestedAnnotation, Annotation<?>> annotations, DataAccessProvider dataAccessProvider) {
        if (annotations.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<SuggestedAnnotation, Set<ConditionalResponse>> issues = new HashMap<SuggestedAnnotation, Set<ConditionalResponse>>();
        int idx = 0;
        log.perfLog("Beginning update loop for annotations");
        DataIterator iter = dataAccessProvider.getDataIterator();
        while (iter.hasNext()) {
            DataRow dataRow = (DataRow)iter.next();
            int dataRowIndex = idx++;
            long numberOfErrors = annotations.entrySet().stream().filter(a -> {
                SuggestedAnnotation annotationSuggestion = (SuggestedAnnotation)a.getKey();
                Annotation annotation = (Annotation)a.getValue();
                Either<Integer, DataRowAdapter> maybeDataRow = DataRowAdapter.build(dataRow, annotationSuggestion, dataRowIndex);
                ConditionalResponse response = this.validateDataRow(maybeDataRow, annotation, dataAccessProvider.getMetaData());
                if (!response.valid()) {
                    return this.handleInvalidResponse((Map<SuggestedAnnotation, Set<ConditionalResponse>>)issues, annotationSuggestion, response, (Map.Entry<SuggestedAnnotation, Annotation<?>>)a);
                }
                annotation.update((DataRowAdapter)maybeDataRow.getRight());
                return false;
            }).count();
            if (numberOfErrors <= 0L) continue;
            break;
        }
        log.perfStop("Completed update loop for annotations");
        return issues;
    }

    private boolean handleInvalidResponse(Map<SuggestedAnnotation, Set<ConditionalResponse>> issues, SuggestedAnnotation annotationSuggestion, ConditionalResponse response, Map.Entry<SuggestedAnnotation, Annotation<?>> a) {
        log.debug("Missing data row found for annotation={}", (Object)a.getKey());
        issues.putIfAbsent(annotationSuggestion, Sets.newHashSet());
        issues.get(annotationSuggestion).add(response);
        return response.isError();
    }

    private Map<SuggestedAnnotation, Set<ConditionalResponse>> postUpdateAndBuildResult(Map<SuggestedAnnotation, Annotation<?>> validatedAnnotations) {
        HashMap<SuggestedAnnotation, Set<ConditionalResponse>> postUpdateIssues = new HashMap<SuggestedAnnotation, Set<ConditionalResponse>>();
        validatedAnnotations.entrySet().forEach(validatedAnnotation -> {
            Annotation annotation = (Annotation)validatedAnnotation.getValue();
            log.debug("Performing post-update of annotation - annotation={}", (Object)annotation.getClass().getSimpleName());
            ConditionalResponse postUpdateResponse = annotation.postUpdate();
            log.debug("Completed post-update of annotation - annotation={}", (Object)annotation.getClass().getSimpleName());
            if (postUpdateResponse == ConditionalResponses.SUCCESS) {
                log.debug("Building result for annotation - annotation={}", (Object)annotation.getClass().getSimpleName());
                annotation.setResult();
                log.debug("Completed building result for annotation - annotation={}", (Object)annotation.getClass().getSimpleName());
            } else {
                postUpdateIssues.put((SuggestedAnnotation)validatedAnnotation.getKey(), Sets.newHashSet((Object[])new ConditionalResponse[]{postUpdateResponse}));
            }
        });
        log.perfLog("Completed post-update and build result of all annotations");
        log.perfStop("Completed update and build loop for annotations");
        return postUpdateIssues;
    }

    private ConditionalResponse validateDataRow(Either<Integer, DataRowAdapter> maybeDataRow, Annotation<?> annotation, MetaData metadata) {
        return (ConditionalResponse)maybeDataRow.map(invalidFieldIndex -> this.getResponseForInvalidField((int)invalidFieldIndex, annotation, metadata), dataRow -> AnnotationExecutor.getResponseFromDataRowValidation(dataRow, annotation, metadata));
    }

    private ConditionalResponse getResponseForInvalidField(int invalidFieldIndex, Annotation<?> annotation, MetaData metadata) {
        return ConditionalResponses.INVALID_DATA_RECORD_WARNING(metadata.getFieldDisplayLabel(invalidFieldIndex));
    }

    private static ConditionalResponse getResponseFromDataRowValidation(DataRowAdapter dataRow, Annotation<?> annotation, MetaData metadata) {
        if (!(annotation instanceof DataRowValidator)) {
            return ConditionalResponses.SUCCESS;
        }
        ConditionalResponse validRowResponse = ((DataRowValidator)((Object)annotation)).validateDataRow(dataRow);
        if (!validRowResponse.valid()) {
            return validRowResponse;
        }
        return ConditionalResponses.SUCCESS;
    }
}

