/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.api;

import com.ibm.bi.predict.dataaccess.DataRow;
import com.ibm.bi.predict.sa.execution.annotation.impl.math.StatisticsMap;
import com.ibm.bi.predict.sa.execution.api.SuggestedAnnotation;
import com.ibm.bi.predict.sa.execution.utils.Either;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class DataRowAdapter {
    private DataRow dataRow;
    private int targetIndex;
    private List<Integer> explanatoryIndexes;
    private int dataRowIndex;

    protected DataRowAdapter(DataRow dataRow, int targetIndex, List<Integer> explanatoryIndexes, int dataRowIndex) {
        this.dataRow = dataRow;
        this.targetIndex = targetIndex;
        this.explanatoryIndexes = explanatoryIndexes;
        this.dataRowIndex = dataRowIndex;
    }

    public static Either<Integer, DataRowAdapter> build(DataRow dataRow, SuggestedAnnotation annotationSuggestion, int dataRowIndex) {
        int targetIndex = annotationSuggestion.indexOfTarget;
        List<Integer> explanatoryIndices = annotationSuggestion.indexesOfExplanatoryFields;
        List<String> reqStats = annotationSuggestion.reqStats;
        Optional<Integer> invalidFieldIndex = DataRowAdapter.isValidRow(dataRow, targetIndex, explanatoryIndices, reqStats);
        return invalidFieldIndex.isPresent() ? Either.left((Object)invalidFieldIndex.get()) : Either.right((Object)new DataRowAdapter(dataRow, targetIndex, explanatoryIndices, dataRowIndex));
    }

    private static Optional<Integer> isValidRow(DataRow dataRow, int targetIndex, List<Integer> explanatoryIndices, List<String> reqStats) {
        double targetValue = dataRow.getValue(targetIndex);
        if (Double.isNaN(targetValue)) {
            return Optional.of(targetIndex);
        }
        Iterator<Object> iterator = explanatoryIndices.iterator();
        while (iterator.hasNext()) {
            int explIdx = iterator.next();
            if (!Double.isNaN(dataRow.getValue(explIdx))) continue;
            return Optional.of(explIdx);
        }
        for (String reqStat : reqStats) {
            if (DataRowAdapter.isValidStatistic(dataRow, reqStat, targetIndex)) continue;
            return Optional.of(targetIndex);
        }
        return Optional.empty();
    }

    private static boolean isValidStatistic(DataRow dataRow, String reqStat, int targetIndex) {
        double statValue = dataRow.getStatistic(reqStat, targetIndex);
        return !Double.isNaN(statValue);
    }

    public double getTargetValue() {
        return this.dataRow.getValue(this.targetIndex);
    }

    public double getExplanatoryValue() {
        return this.getExplanatoryValue(0);
    }

    public double getExplanatoryValue(int explanatoryIndex) {
        return this.dataRow.getValue(this.explanatoryIndexes.get(explanatoryIndex).intValue());
    }

    public double getTargetStatistic(String statName) {
        return this.dataRow.getStatistic(statName, this.targetIndex);
    }

    public double getTargetStatistic(StatisticsMap.StatisticName statName) {
        return this.getTargetStatistic(statName.toString());
    }

    public double getExplanatoryStatistic(String statName) {
        return this.dataRow.getStatistic(statName, this.explanatoryIndexes.get(0).intValue());
    }

    public double getFieldValueByIndex(int index) {
        return this.dataRow.getValue(index);
    }

    public int getDataRowIndex() {
        return this.dataRowIndex;
    }
}

