/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.api;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.ibm.bi.predict.dataaccess.Decorator;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.exceptions.PredictException;
import com.ibm.bi.predict.sa.execution.annotation.Annotation;
import com.ibm.bi.predict.sa.execution.annotation.AnnotationFactory;
import com.ibm.bi.predict.sa.execution.annotation.ConditionalResponses;
import com.ibm.bi.predict.sa.execution.annotation.response.ConditionalResponse;
import com.ibm.bi.predict.sa.execution.annotation.result.AnnotationResult;
import com.ibm.bi.predict.sa.execution.annotation.result.ExecutionResult;
import com.ibm.bi.predict.sa.execution.api.AnnotationExecutor;
import com.ibm.bi.predict.sa.execution.api.Diagnostics;
import com.ibm.bi.predict.sa.execution.api.ExecutionContext;
import com.ibm.bi.predict.sa.execution.api.ExecutionResponse;
import com.ibm.bi.predict.sa.execution.api.OutputService;
import com.ibm.bi.predict.sa.execution.api.Preconditions;
import com.ibm.bi.predict.sa.execution.api.SuggestedAnnotation;
import com.ibm.bi.predict.service.PredictServiceFramework;
import com.ibm.bi.predict.service.PredictServiceRequest;
import com.ibm.bi.predict.service.PredictServiceResponse;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ExecutionServiceImpl
implements PredictServiceFramework {
    private static final Logger log = PredictLoggerFactory.getLogger(ExecutionServiceImpl.class);
    private final AnnotationFactory annotationFactory;
    private final AnnotationExecutor annotationExecutor;
    private final OutputService outputService;

    public ExecutionServiceImpl(AnnotationFactory annotationFactory, AnnotationExecutor annotationExecutor, OutputService outputService) {
        this.annotationFactory = annotationFactory;
        this.annotationExecutor = annotationExecutor;
        this.outputService = outputService;
    }

    public PredictServiceResponse run(Collection<PredictServiceRequest> requests, Locale locale) {
        if (requests == null || locale == null) {
            throw new IllegalArgumentException("Invalid inputs while attempting to execute annotations");
        }
        return this.getExecutionResponse(this.executeAll(requests), locale);
    }

    public List<ExecutionResult> executeAll(Collection<PredictServiceRequest> requests) {
        if (requests == null) {
            throw new IllegalArgumentException("Invalid inputs while attempting to execute annotations");
        }
        log.perfStart();
        List<ExecutionResult> executionResults = requests.stream().map(this::execute).collect(Collectors.toList());
        log.perfStop("Completed execution of annotations");
        return executionResults;
    }

    private ExecutionResult execute(PredictServiceRequest request) {
        Set<ConditionalResponse> failedPreconditions = ExecutionServiceImpl.validateGlobalPreconditions(request);
        if (!failedPreconditions.isEmpty()) {
            log.warn("Annotation pre-conditions failed, number of failed conditions={}", (Object)failedPreconditions.size());
            return ExecutionServiceImpl.createFailedExecutionResult(request, failedPreconditions, ((ExecutionContext)request.getContext()).suggestedAnnotations());
        }
        Map<SuggestedAnnotation, Annotation<?>> annotations = this.createAnnotationsFromSuggestions(request);
        Map<SuggestedAnnotation, ConditionalResponse> invalidAnnotations = this.validateAnnotations(annotations);
        Map<SuggestedAnnotation, Set<ConditionalResponse>> executionIssues = this.executeAnnotations(request, annotations);
        this.decorateWithResults(request, annotations);
        this.addData(request, annotations);
        boolean sortDone = this.sort(request, annotations, executionIssues);
        return ExecutionServiceImpl.getExecutionResult(request, ExecutionServiceImpl.getResults(annotations), executionIssues, invalidAnnotations, sortDone);
    }

    private static ExecutionResult createFailedExecutionResult(PredictServiceRequest request, Set<ConditionalResponse> failedAnnotationPreconditions, Set<SuggestedAnnotation> suggestedAnnotations) {
        HashMap<SuggestedAnnotation, Set<ConditionalResponse>> failures = new HashMap<SuggestedAnnotation, Set<ConditionalResponse>>();
        suggestedAnnotations.forEach(sa -> failures.put((SuggestedAnnotation)sa, failedAnnotationPreconditions));
        return ExecutionResult.failure(failures, ((ExecutionContext)request.getContext()).originalRequest(), ExecutionServiceImpl.getDiagnostics(request));
    }

    private static ExecutionResult getExecutionResult(PredictServiceRequest request, ListMultimap<SuggestedAnnotation, AnnotationResult<?>> results, Map<SuggestedAnnotation, Set<ConditionalResponse>> executionIssues, Map<SuggestedAnnotation, ConditionalResponse> invalidAnnotations, boolean sortDone) {
        invalidAnnotations.entrySet().stream().forEach(e -> {
            executionIssues.putIfAbsent((SuggestedAnnotation)e.getKey(), Sets.newHashSet());
            ((Set)executionIssues.get(e.getKey())).add(e.getValue());
        });
        return new ExecutionResult(executionIssues, results, ((ExecutionContext)request.getContext()).originalRequest(), ExecutionServiceImpl.getDiagnostics(request), sortDone);
    }

    private static ListMultimap<SuggestedAnnotation, AnnotationResult<?>> getResults(Map<SuggestedAnnotation, Annotation<?>> annotations) {
        ArrayListMultimap results = ArrayListMultimap.create();
        annotations.forEach((arg_0, arg_1) -> ExecutionServiceImpl.lambda$getResults$2((ListMultimap)results, arg_0, arg_1));
        return results;
    }

    private void decorateWithResults(PredictServiceRequest request, Map<SuggestedAnnotation, Annotation<?>> annotations) {
        Decorator decorator = ExecutionServiceImpl.decorator(request);
        Locale locale = request.getLocale();
        log.perfLog("Beginning to decorate output with results");
        annotations.forEach((suggested, actual) -> {
            actual.decorate(decorator, (SuggestedAnnotation)suggested, locale);
            log.debug("Completed decoration for annotation - annotation={}", (Object)actual.getClass().getSimpleName());
        });
        log.perfLog("Completed decoration of all annotation results");
    }

    private void addData(PredictServiceRequest request, Map<SuggestedAnnotation, Annotation<?>> annotations) {
        Decorator decorator = ExecutionServiceImpl.decorator(request);
        Locale locale = request.getLocale();
        log.perfLog("Beginning to add data to output from results");
        annotations.forEach((suggested, actual) -> {
            actual.addData(decorator, (SuggestedAnnotation)suggested, locale);
            log.debug("Completed data additions for annotation - annotation={}", (Object)actual.getClass().getSimpleName());
        });
        log.perfLog("Completed adding data from all annotation results");
    }

    private boolean sort(PredictServiceRequest request, Map<SuggestedAnnotation, Annotation<?>> annotations, Map<SuggestedAnnotation, Set<ConditionalResponse>> executionIssues) {
        log.perfLog("Beginning to sort output");
        int sortedCount = 0;
        for (Map.Entry<SuggestedAnnotation, Annotation<?>> entry : annotations.entrySet()) {
            Annotation<?> annotation = entry.getValue();
            if (!this.annotationSort(annotation, request)) continue;
            if (++sortedCount > 1) {
                log.error("Multiple annotations sorting same request - annotation={}", (Object)annotation.getClass().getSimpleName());
                throw new PredictException("Multiple annotations attempting to sort same request");
            }
            executionIssues.get(entry.getKey()).add(ConditionalResponses.OUTPUT_REORDERED);
        }
        log.perfLog("Completed sorting of the output");
        return sortedCount > 0;
    }

    private boolean annotationSort(Annotation<?> annotation, PredictServiceRequest request) {
        if (annotation.sort(request.getData().asDataAccessProvider(), request.getLocale())) {
            log.debug("Completed sorting for annotation - annotation={}", (Object)annotation.getClass().getSimpleName());
            return true;
        }
        return false;
    }

    private Map<SuggestedAnnotation, Set<ConditionalResponse>> executeAnnotations(PredictServiceRequest request, Map<SuggestedAnnotation, Annotation<?>> annotations) {
        if (annotations.isEmpty()) {
            return Maps.newHashMap();
        }
        log.perfLog("Beginning to execute annotations");
        Map<SuggestedAnnotation, Set<ConditionalResponse>> executionIssues = this.annotationExecutor.execute(annotations, request);
        Set<SuggestedAnnotation> errorAnnotations = ExecutionServiceImpl.getAnnotationsEndingInError(executionIssues);
        errorAnnotations.forEach(eA -> annotations.keySet().remove(eA));
        log.perfLog("Finished executing annotations");
        return executionIssues;
    }

    public static Set<SuggestedAnnotation> getAnnotationsEndingInError(Map<SuggestedAnnotation, Set<ConditionalResponse>> executionIssues) {
        return executionIssues.entrySet().stream().filter(e -> !((Set)e.getValue()).isEmpty()).filter(e -> ((Set)e.getValue()).stream().allMatch(ConditionalResponse::isError)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).keySet();
    }

    private Map<SuggestedAnnotation, ConditionalResponse> validateAnnotations(Map<SuggestedAnnotation, Annotation<?>> annotations) {
        Map<SuggestedAnnotation, ConditionalResponse> invalidAnnotations = Preconditions.validateAnnotations(annotations);
        annotations.keySet().removeAll(invalidAnnotations.keySet());
        if (!invalidAnnotations.isEmpty()) {
            log.debug("Invalid annotations found for {}", invalidAnnotations.keySet());
        }
        log.perfLog("Finished validating annotations");
        return invalidAnnotations;
    }

    private Map<SuggestedAnnotation, Annotation<?>> createAnnotationsFromSuggestions(PredictServiceRequest request) {
        try {
            Set<SuggestedAnnotation> suggestions = ((ExecutionContext)request.getContext()).suggestedAnnotations();
            Map<SuggestedAnnotation, Annotation<?>> annotations = this.annotationFactory.getAnnotationsFromSuggestions(suggestions, ExecutionServiceImpl.metadata(request));
            log.perfLog("Finished creating annotations from suggestions");
            return annotations;
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.warn("Received exception while creating annotations from request - message={}", (Object)e.getMessage(), (Object)e);
            return Collections.emptyMap();
        }
    }

    private static Set<ConditionalResponse> validateGlobalPreconditions(PredictServiceRequest request) {
        return Preconditions.validateGlobal(request);
    }

    public ExecutionResponse getExecutionResponse(List<ExecutionResult> executionResults, Locale locale) {
        ExecutionResponse response = this.outputService.getExecutionResponse(executionResults, locale);
        log.perfStop("Completed execution requests");
        return response;
    }

    private static Diagnostics getDiagnostics(PredictServiceRequest request) {
        return new Diagnostics(log.getTime(), ExecutionServiceImpl.metadata(request).getConceptsMap());
    }

    private static Decorator decorator(PredictServiceRequest request) {
        return request.getData().asDataAccessProvider().getDecorator();
    }

    private static MetaData metadata(PredictServiceRequest request) {
        return request.getData().asDataAccessProvider().getMetaData();
    }

    private static /* synthetic */ void lambda$getResults$2(ListMultimap results, SuggestedAnnotation suggested, Annotation actual) {
        results.put((Object)suggested, actual.getResult());
    }
}

