/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.api;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.ibm.bi.predict.sa.execution.annotation.MessageService;
import com.ibm.bi.predict.sa.execution.annotation.response.ConditionalResponse;
import com.ibm.bi.predict.sa.execution.annotation.response.ConditionalResponseConstants;
import com.ibm.bi.predict.sa.execution.annotation.response.FailedAnnotationResponse;
import com.ibm.bi.predict.sa.execution.annotation.response.Title;
import com.ibm.bi.predict.sa.execution.annotation.result.AnnotationResult;
import com.ibm.bi.predict.sa.execution.annotation.result.ExecutionResult;
import com.ibm.bi.predict.sa.execution.annotation.result.ResultsConsolidator;
import com.ibm.bi.predict.sa.execution.api.ExecutionResponse;
import com.ibm.bi.predict.sa.execution.api.SuggestedAnnotation;
import com.ibm.bi.predict.sa.execution.api.TitleGenerator;
import com.ibm.bi.predict.sa.execution.api.messagesgenerator.Caption;
import com.ibm.bi.predict.sa.execution.api.messagesgenerator.CaptionsForFailures;
import com.ibm.bi.predict.sa.execution.api.messagesgenerator.CaptionsForResults;
import com.ibm.bi.predict.sa.execution.api.messagesgenerator.ErrorsAndWarnings;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.json.JSONObject;

public class OutputService {
    private static final Logger log = PredictLoggerFactory.getLogger(OutputService.class);
    private final ResultsConsolidator resultsConsolidator;
    private final MessageService messageService;

    public OutputService(ResultsConsolidator resultsConsolidator, MessageService messageService) {
        this.resultsConsolidator = resultsConsolidator;
        this.messageService = messageService;
    }

    public ExecutionResponse getExecutionResponse(List<ExecutionResult> executionResults, Locale locale) {
        log.debug("Generating execution response");
        ExecutionResult results = this.resultsConsolidator.consolidateExecutionResults(executionResults);
        JSONObject predictResults = results.getPredictResults();
        JSONObject originalRequest = results.originalRequest;
        ListMultimap<SuggestedAnnotation, AnnotationResult<?>> annotationResults = results.getResults();
        Map<SuggestedAnnotation, Set<ConditionalResponse>> executionIssues = results.getExecutionIssues();
        Map<String, List<Caption>> captions = this.generateCaptions(annotationResults, executionIssues, locale);
        Set<ConditionalResponse> allIssues = this.getAllIssues(executionIssues);
        Set<FailedAnnotationResponse> warnings = ErrorsAndWarnings.getWarnings(allIssues, this.messageService, locale);
        warnings = this.sortWarnings(warnings);
        Set<FailedAnnotationResponse> errors = ErrorsAndWarnings.getErrors(allIssues, this.messageService, locale);
        boolean reordered = results.isReordered();
        if (warnings.isEmpty() && errors.isEmpty() && !captions.isEmpty()) {
            return ExecutionResponse.getSuccessfulResponse(captions, this.createTitle(annotationResults, locale), predictResults, originalRequest, results.getDiagnostics(), reordered);
        }
        if (results.getResults().isEmpty() && !errors.isEmpty()) {
            return ExecutionResponse.getFailureResponse(captions, warnings, errors, Title.empty(), predictResults, originalRequest, results.getDiagnostics(), reordered);
        }
        return ExecutionResponse.getPartialSuccessResponse(captions, warnings, errors, this.createTitle(annotationResults, locale), predictResults, originalRequest, results.getDiagnostics(), reordered);
    }

    private Set<FailedAnnotationResponse> sortWarnings(Set<FailedAnnotationResponse> warnings) {
        LinkedHashSet<FailedAnnotationResponse> sortedWarnings = new LinkedHashSet<FailedAnnotationResponse>();
        ArrayList<FailedAnnotationResponse> conditionalResponseFailures = new ArrayList<FailedAnnotationResponse>();
        for (FailedAnnotationResponse f2 : warnings) {
            if (ConditionalResponseConstants.LOOKUP.containsKey(f2.getId())) {
                conditionalResponseFailures.add(f2);
                continue;
            }
            sortedWarnings.add(f2);
        }
        conditionalResponseFailures.sort(Comparator.comparingInt(f -> ConditionalResponseConstants.LOOKUP.get(f.getId()).ordinal()));
        conditionalResponseFailures.forEach(f -> sortedWarnings.add((FailedAnnotationResponse)f));
        return sortedWarnings;
    }

    private Map<String, List<Caption>> generateCaptions(ListMultimap<SuggestedAnnotation, AnnotationResult<?>> results, Map<SuggestedAnnotation, Set<ConditionalResponse>> executionIssues, Locale locale) {
        Map<String, List<Caption>> resultCaptions = CaptionsForResults.getCaptionsForResults(results, this.messageService, locale);
        Map<String, List<Caption>> issueCaptions = CaptionsForFailures.getCaptionsForFailures(executionIssues, this.messageService, locale);
        HashMap<String, List<Caption>> captions = new HashMap<String, List<Caption>>();
        Stream.of(resultCaptions, issueCaptions).flatMap(m -> m.entrySet().stream()).forEach(e -> {
            String annotationType = (String)e.getKey();
            List c = (List)e.getValue();
            captions.putIfAbsent(annotationType, Lists.newArrayList());
            ((List)captions.get(annotationType)).addAll(c);
        });
        return captions;
    }

    private Set<ConditionalResponse> getAllIssues(Map<SuggestedAnnotation, Set<ConditionalResponse>> executionIssues) {
        return executionIssues.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Title createTitle(ListMultimap<SuggestedAnnotation, AnnotationResult<?>> annotationResults, Locale locale) {
        return TitleGenerator.getTitle(annotationResults, this.messageService, locale);
    }
}

