/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.api;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.types.StatisticStatus;
import com.ibm.bi.predict.sa.execution.annotation.Annotation;
import com.ibm.bi.predict.sa.execution.annotation.ConditionalResponses;
import com.ibm.bi.predict.sa.execution.annotation.response.Conditional;
import com.ibm.bi.predict.sa.execution.annotation.response.ConditionalResponse;
import com.ibm.bi.predict.sa.execution.api.ExecutionContext;
import com.ibm.bi.predict.sa.execution.api.SuggestedAnnotation;
import com.ibm.bi.predict.service.PredictServiceRequest;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Preconditions {
    private static final Logger log = PredictLoggerFactory.getLogger(Preconditions.class);

    private Preconditions() {
    }

    public static Set<ConditionalResponse> validateGlobal(PredictServiceRequest request) {
        HashSet<ConditionalResponse> violatedPreconditions = new HashSet<ConditionalResponse>();
        DataAccessProvider dataAccessProvider = request.getData().asDataAccessProvider();
        if (!Preconditions.dataHasRequiredStatistics(request)) {
            Set<String> violatingFields = Preconditions.fieldsWithMissingRequiredStatistics((ExecutionContext)request.getContext(), request.getData().asDataAccessProvider());
            violatingFields.forEach(fieldName -> violatedPreconditions.add(ConditionalResponses.INVALID_FIELD(fieldName)));
        }
        if (Preconditions.dataIsClipped(dataAccessProvider)) {
            violatedPreconditions.add(ConditionalResponses.CLIPPED_DATA);
        }
        if (Preconditions.getRowCount(dataAccessProvider) == 0) {
            violatedPreconditions.add(ConditionalResponses.EMPTY_DATA_OBJECT);
        }
        if (!violatedPreconditions.isEmpty()) {
            log.warn("Cannot execute annotations, failed to validate preconditions - numViolations={}", (Object)violatedPreconditions.size());
        }
        return violatedPreconditions;
    }

    public static Map<SuggestedAnnotation, ConditionalResponse> validateAnnotations(Map<SuggestedAnnotation, Annotation<?>> annotations) {
        Map<SuggestedAnnotation, ConditionalResponse> invalidAnnotations = annotations.entrySet().stream().filter(a -> {
            Annotation annotation = (Annotation)a.getValue();
            ConditionalResponse validationResponse = Preconditions.validateAnnotation(annotation);
            return !validationResponse.valid();
        }).collect(Collectors.toMap(Map.Entry::getKey, value -> Preconditions.validateAnnotation((Annotation)value.getValue())));
        if (!invalidAnnotations.isEmpty()) {
            log.warn("Found invalid annotations during validations - numInvalid={}", (Object)invalidAnnotations.size());
        }
        return invalidAnnotations;
    }

    private static boolean dataHasRequiredStatistics(PredictServiceRequest request) {
        return Preconditions.fieldsWithMissingRequiredStatistics((ExecutionContext)request.getContext(), request.getData().asDataAccessProvider()).isEmpty();
    }

    private static Set<String> fieldsWithMissingRequiredStatistics(ExecutionContext context, DataAccessProvider dataProvider) {
        return context.suggestedAnnotations().stream().filter(s -> !Preconditions.suggestionHasRequiredStatistics(s, dataProvider)).map(s -> dataProvider.getMetaData().getFieldDisplayLabel(s.indexOfTarget)).collect(Collectors.toSet());
    }

    private static boolean suggestionHasRequiredStatistics(SuggestedAnnotation suggestion, DataAccessProvider dataAccessProvider) {
        MetaData metadata = dataAccessProvider.getMetaData();
        return suggestion.reqStats.stream().allMatch(s -> {
            StatisticStatus status = metadata.getStatisticStatus(s, suggestion.indexOfTarget);
            return status == StatisticStatus.AVAILABLE;
        });
    }

    private static ConditionalResponse validateAnnotation(Annotation<?> annotation) {
        if (!(annotation instanceof Conditional)) {
            return ConditionalResponses.SUCCESS;
        }
        Conditional conditionalAnnotation = (Conditional)((Object)annotation);
        ConditionalResponse response = conditionalAnnotation.assertPreconditions();
        if (!response.valid()) {
            log.warn("Annotation pre-condition failed - annotation={}", (Object)annotation.getClass().getSimpleName());
        }
        return response;
    }

    private static boolean dataIsClipped(DataAccessProvider dataAccessProvider) {
        MetaData metaData = dataAccessProvider.getMetaData();
        return metaData.isClippedData();
    }

    private static int getRowCount(DataAccessProvider dataAccessProvider) {
        return dataAccessProvider.getMetaData().rowCount();
    }
}

