/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.api;

import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.utils.JsonUtils;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class SuggestedAnnotation {
    private static final Logger log = PredictLoggerFactory.getLogger(SuggestedAnnotation.class);
    public final List<String> dataItems;
    public final List<String> roles;
    public final String type;
    public final String algorithm;
    public final int indexOfTarget;
    public final List<Integer> indexesOfExplanatoryFields;
    public final List<String> reqStats;
    public final Map<String, Object> modelOptions;

    public SuggestedAnnotation(List<String> dataItems, List<String> roles, String type, int indexOfTarget, List<Integer> indexOfExplanatoryField, List<String> reqStats) {
        this(dataItems, roles, type, null, indexOfTarget, indexOfExplanatoryField, reqStats, Collections.emptyMap());
    }

    public SuggestedAnnotation(List<String> dataItems, List<String> roles, String type, String algorithm, int indexOfTarget, List<Integer> indexesOfExplanatoryFields, List<String> reqStats, Map<String, Object> modelOptions) {
        this.dataItems = dataItems;
        this.roles = roles;
        this.type = type;
        this.algorithm = algorithm;
        this.indexOfTarget = indexOfTarget;
        this.indexesOfExplanatoryFields = indexesOfExplanatoryFields;
        this.reqStats = reqStats;
        this.modelOptions = modelOptions != null ? modelOptions : Collections.emptyMap();
    }

    public static SuggestedAnnotation fromJson(JSONObject o, MetaData metadata) throws JSONException {
        List<String> roles = SuggestedAnnotation.list("roles", o);
        List<String> dataItems = SuggestedAnnotation.list("dataItems", o);
        List<String> reqStats = SuggestedAnnotation.list("reqStats", o);
        List allExplIndexes = IntStream.range(0, roles.size()).boxed().filter(i -> "explanatory".equals(roles.get((int)i))).collect(Collectors.toList());
        List<Integer> indexesOfExplanatoryFields = allExplIndexes.stream().mapToInt(explIndex -> SuggestedAnnotation.getFieldIndex(dataItems, (String)dataItems.get((int)explIndex), metadata)).boxed().collect(Collectors.toList());
        int responseIndex = roles.indexOf("response");
        int indexOfResponseField = SuggestedAnnotation.getFieldIndex(dataItems, dataItems.get(responseIndex), metadata);
        List<String> parts = SuggestedAnnotation.list("parts", o);
        String algorithm = null;
        if (!parts.isEmpty()) {
            algorithm = parts.get(0);
        }
        Map modelOptions = JsonUtils.jsonObjectToMap((JSONObject)JsonUtils.getOptionalJSONObject((JSONObject)o, (String)"modelOptions"));
        return new SuggestedAnnotation(dataItems, roles, o.getString("type"), algorithm, indexOfResponseField, indexesOfExplanatoryFields, reqStats, modelOptions);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.dataItems).append(this.roles).append((Object)this.type).append((Object)this.algorithm).append(this.indexOfTarget).append(this.indexesOfExplanatoryFields).append(this.reqStats).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SuggestedAnnotation)) {
            return false;
        }
        SuggestedAnnotation other = (SuggestedAnnotation)obj;
        return new EqualsBuilder().append(this.dataItems, other.dataItems).append(this.roles, other.roles).append((Object)this.type, (Object)other.type).append((Object)this.algorithm, (Object)other.algorithm).append(this.indexOfTarget, other.indexOfTarget).append(this.indexesOfExplanatoryFields, other.indexesOfExplanatoryFields).append(this.reqStats, other.reqStats).append(this.modelOptions, other.modelOptions).isEquals();
    }

    public String toString() {
        return String.format("[ dataItems: [%s], roles: [%s], type: %s, algorithm: %s, indexOfTarget: %d, indexesOfExplanatoryFields: [%s], reqStats: [%s] ]", String.join((CharSequence)", ", this.dataItems), String.join((CharSequence)", ", this.roles), this.type, this.algorithm, this.indexOfTarget, this.indexesOfExplanatoryFields.stream().map(Object::toString).collect(Collectors.joining(", ")), String.join((CharSequence)", ", this.reqStats));
    }

    private static List<String> list(String key, JSONObject o) {
        try {
            JSONArray l = o.getJSONArray(key);
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < l.size(); ++i) {
                result.add(l.getString(i));
            }
            return result;
        }
        catch (JSONException e) {
            log.warn("Error while trying to get parameters as list - reason=%s", (Object)e.getMessage(), (Object)e);
            throw new IllegalArgumentException("Found invalid params while converting to list");
        }
    }

    private static int getFieldIndex(List<String> dataItems, String fieldId, MetaData meta) {
        return IntStream.range(0, meta.fieldCount()).filter(i -> fieldId.equals(meta.getFieldIdentifier(i))).findFirst().orElse(-1);
    }
}

