/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.api.messagesgenerator;

import com.ibm.bi.predict.sa.execution.annotation.MessageService;
import com.ibm.bi.predict.sa.execution.annotation.impl.types.FitLineType;
import com.ibm.bi.predict.sa.execution.annotation.result.AnnotationResult;
import com.ibm.bi.predict.sa.execution.annotation.result.FitLineResult;
import com.ibm.bi.predict.sa.execution.api.messagesgenerator.Caption;
import com.ibm.bi.predict.sa.execution.api.messagesgenerator.MessagesGeneratorCommon;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

class FitLineMessages {
    private FitLineMessages() {
    }

    static List<Caption> getMessagesForFitLine(AnnotationResult<?> result, MessageService.MessageBundle messageBundle, Locale locale) {
        if (!result.isEmpty() && !(result.getResult() instanceof List)) {
            throw MessagesGeneratorCommon.illegalArgument();
        }
        List fitLineData = (List)result.getResult();
        return fitLineData.stream().map(lineData -> FitLineMessages.getCaptionForFitLine(lineData, messageBundle, locale)).collect(Collectors.toList());
    }

    private static Caption getCaptionForFitLine(FitLineResult.FitLineData lineData, MessageService.MessageBundle messageBundle, Locale locale) {
        String shortMessage = MessagesGeneratorCommon.getShortMessage(messageBundle, "FIT_LINE_" + (Object)((Object)lineData.equation.getType()), new Object[0]);
        String responseName = lineData.responseName;
        String explanatoryName = lineData.explanatoryName;
        String groupName = lineData.groupName;
        String categoryName = lineData.categoryName;
        boolean grouping = lineData.categoryName != null;
        String fitLineMessageKey = FitLineMessages.getFitLineMessageKey(lineData);
        String equation = lineData.equation.getEquation(locale);
        if (grouping) {
            List<String> categoryNameOrNoValue = MessagesGeneratorCommon.getCategoryNames(Arrays.asList(categoryName), messageBundle);
            categoryName = categoryNameOrNoValue.get(0);
        }
        String longMessage = lineData.equation.getType() == FitLineType.QUADRATIC && grouping ? MessagesGeneratorCommon.getLongMessage(messageBundle, fitLineMessageKey, groupName, categoryName, responseName, explanatoryName, equation) : (lineData.equation.getType() == FitLineType.QUADRATIC ? MessagesGeneratorCommon.getLongMessage(messageBundle, fitLineMessageKey, responseName, explanatoryName, equation) : (lineData.equation.getType() == FitLineType.NONE && grouping ? MessagesGeneratorCommon.getLongMessage(messageBundle, fitLineMessageKey, groupName, categoryName, responseName, explanatoryName) : (lineData.equation.getType() == FitLineType.NONE ? MessagesGeneratorCommon.getLongMessage(messageBundle, fitLineMessageKey, responseName, explanatoryName) : (grouping ? MessagesGeneratorCommon.getLongMessage(messageBundle, fitLineMessageKey, groupName, categoryName, responseName, explanatoryName, equation) : MessagesGeneratorCommon.getLongMessage(messageBundle, fitLineMessageKey, responseName, explanatoryName, equation)))));
        longMessage = MessagesGeneratorCommon.formatLongMessage(longMessage, locale);
        return new Caption(shortMessage, longMessage);
    }

    private static String getFitLineMessageKey(FitLineResult.FitLineData lineData) {
        boolean isGrouped = lineData.categoryName != null;
        String fitLineMessageKey = "FIT_LINE_" + (Object)((Object)lineData.equation.getType());
        if (isGrouped) {
            fitLineMessageKey = fitLineMessageKey + "_GROUP";
        }
        if (lineData.equation.getType() != FitLineType.NONE) {
            fitLineMessageKey = fitLineMessageKey + "_" + lineData.strength.name();
        }
        return fitLineMessageKey;
    }
}

