/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.api.messagesgenerator;

import com.ibm.bi.predict.messages.NoValueReplacement;
import com.ibm.bi.predict.sa.execution.annotation.MessageService;
import com.ibm.bi.predict.sa.execution.annotation.impl.types.CategoryName;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class MessagesGeneratorCommon {
    public static final String AVERAGE = "AVERAGE";
    public static final String MEANINGFUL_DIFFERENCES = "MEANINGFUL_DIFFERENCES";
    public static final String PREDICTIVE_STRENGTH = "PREDICTIVE_STRENGTH";
    public static final String FIT_LINE = "FIT_LINE";
    public static final String MODE = "MODE";
    public static final String MODENONE = "MODENONE";
    public static final String MODE2 = "MODE2";
    public static final String MODE3 = "MODE3";
    public static final String MODEN = "MODEN";
    public static final String MODEALL = "MODEALL";
    public static final String TIME_SERIES = "TIME_SERIES";
    private static final String NLT = "NLT";
    static final String BUNDLE_NAME = "Predict_Smart_Annotations";
    private static final String NO_VALUE_KEY = "NO_VALUE";
    private static final double SMALL_PERCENT_VALUE = 0.01;
    private static final int MIN_PERCENT_PRECISION = 2;
    private static final int MAX_PERCENT_PRECISION = 4;

    private MessagesGeneratorCommon() {
    }

    public static List<String> getCategoryNames(List<String> catNames, MessageService.MessageBundle messageBundle) {
        return catNames.stream().map(s -> MessagesGeneratorCommon.getCategoryName(s, messageBundle)).collect(Collectors.toList());
    }

    public static String getCategoryName(String catName, MessageService.MessageBundle messageBundle) {
        String noValue = messageBundle.getMessage(NO_VALUE_KEY, new Object[0]);
        return NoValueReplacement.replace((String)catName, (String)noValue);
    }

    public static String getCategoryName(CategoryName catName, MessageService.MessageBundle messageBundle) {
        return catName.categoryNames().stream().map(name -> MessagesGeneratorCommon.getCategoryName(name, messageBundle)).collect(Collectors.joining(" | "));
    }

    public static String getShortMessage(MessageService.MessageBundle messageBundle, String type, Object ... params) {
        return MessagesGeneratorCommon.getMessage(type + "_SHORT", messageBundle, params);
    }

    public static String getLongMessage(MessageService.MessageBundle messageBundle, String type, Object ... params) {
        return MessagesGeneratorCommon.getMessage(type + "_LONG", messageBundle, params);
    }

    private static String getMessage(String key, MessageService.MessageBundle messageBundle, Object ... params) {
        return messageBundle.getMessage(key, params);
    }

    private static String replaceCharacters(String str) {
        return str.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static RuntimeException illegalArgument() {
        return new IllegalArgumentException("Invalid annotation result");
    }

    public static String formatLongMessage(String longMessage, Locale locale) {
        String formattedLongMessage = longMessage;
        if (NLT.equals(locale.getVariant())) {
            formattedLongMessage = MessagesGeneratorCommon.replaceSpecialStrings(formattedLongMessage, "<span class=\"insight-field-name\">");
            formattedLongMessage = MessagesGeneratorCommon.replaceSpecialStrings(formattedLongMessage, "<span class=\"insight-statistic\">");
            return MessagesGeneratorCommon.replaceSpecialStrings(formattedLongMessage, "<span class=\"insight-field-value\">");
        }
        formattedLongMessage = MessagesGeneratorCommon.replaceHtmlTags(longMessage);
        return formattedLongMessage;
    }

    private static String replaceHtmlTags(String str) {
        return str.replaceAll("<span class=\"insight-field-name\">|<span class=\"insight-statistic\">|<span class=\"insight-field-value\">|</span>", "");
    }

    private static String replaceSpecialStrings(String str, String tagStart) {
        Pattern pattern = Pattern.compile(tagStart + "(?<group>.+?)<\\/span>");
        Matcher matcher = pattern.matcher(str);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, tagStart + MessagesGeneratorCommon.replaceCharacters(matcher.group(1)) + "</span>");
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static String formatAsPercentage(double value, Locale locale) {
        NumberFormat df = NumberFormat.getPercentInstance(locale);
        if (value < 0.01) {
            df.setMinimumFractionDigits(2);
            df.setMaximumFractionDigits(4);
            df.setRoundingMode(RoundingMode.DOWN);
        }
        return df.format(value);
    }
}

