/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.api.messagesgenerator;

import com.ibm.bi.predict.sa.execution.annotation.MessageService;
import com.ibm.bi.predict.sa.execution.annotation.result.AnnotationResult;
import com.ibm.bi.predict.sa.execution.annotation.result.ModeResult;
import com.ibm.bi.predict.sa.execution.api.messagesgenerator.Caption;
import com.ibm.bi.predict.sa.execution.api.messagesgenerator.MessagesGeneratorCommon;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class ModeMessages {
    static final double USE_LESSTHAN_THRESHOLD = 1.0E-5;

    private ModeMessages() {
    }

    static List<Caption> getMessagesForMode(AnnotationResult<?> result, MessageService.MessageBundle messageBundle, Locale locale) {
        String longMessage;
        String shortMessage;
        if (!(result.getResult() instanceof ModeResult.ModeData)) {
            throw MessagesGeneratorCommon.illegalArgument();
        }
        ModeResult.ModeData data = (ModeResult.ModeData)result.getResult();
        int count = data.getModeCount();
        String percent = ModeMessages.formatAsPercentage(data.getModePercent(), locale);
        String explanatoryName = data.getExplanatoryName();
        List<String> originalCategories = data.getCategoryLabels();
        int ncats = originalCategories.size();
        List<String> categories = MessagesGeneratorCommon.getCategoryNames(originalCategories, messageBundle);
        if (data.allSame()) {
            shortMessage = MessagesGeneratorCommon.getShortMessage(messageBundle, "MODEALL", percent);
            longMessage = MessagesGeneratorCommon.getLongMessage(messageBundle, "MODEALL", explanatoryName, count, percent);
        } else {
            switch (ncats) {
                case 0: {
                    shortMessage = MessagesGeneratorCommon.getShortMessage(messageBundle, "MODENONE", new Object[0]);
                    longMessage = MessagesGeneratorCommon.getLongMessage(messageBundle, "MODENONE", explanatoryName);
                    break;
                }
                case 1: {
                    String modeCategory = categories.get(0);
                    shortMessage = MessagesGeneratorCommon.getShortMessage(messageBundle, "MODE", modeCategory, percent);
                    longMessage = MessagesGeneratorCommon.getLongMessage(messageBundle, "MODE", explanatoryName, modeCategory, count, percent);
                    break;
                }
                case 2: {
                    shortMessage = MessagesGeneratorCommon.getShortMessage(messageBundle, "MODE2", percent);
                    longMessage = MessagesGeneratorCommon.getLongMessage(messageBundle, "MODE2", explanatoryName, categories.get(0), categories.get(1), count, percent);
                    break;
                }
                case 3: {
                    shortMessage = MessagesGeneratorCommon.getShortMessage(messageBundle, "MODE3", percent);
                    longMessage = MessagesGeneratorCommon.getLongMessage(messageBundle, "MODE3", explanatoryName, categories.get(0), categories.get(1), categories.get(2), count, percent);
                    break;
                }
                default: {
                    shortMessage = MessagesGeneratorCommon.getShortMessage(messageBundle, "MODEN", ncats, percent);
                    longMessage = MessagesGeneratorCommon.getLongMessage(messageBundle, "MODEN", explanatoryName, categories.get(0), categories.get(1), categories.size() - 2, count, percent);
                }
            }
        }
        return Arrays.asList(new Caption(shortMessage, MessagesGeneratorCommon.formatLongMessage(longMessage, locale)));
    }

    public static String formatAsPercentage(double value, Locale locale) {
        if (value < 1.0E-5) {
            return "< " + MessagesGeneratorCommon.formatAsPercentage(1.0E-5, locale);
        }
        return MessagesGeneratorCommon.formatAsPercentage(value, locale);
    }
}

