/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.api.messagesgenerator;

import com.ibm.bi.predict.sa.execution.annotation.MessageService;
import com.ibm.bi.predict.sa.execution.annotation.result.AnnotationResult;
import com.ibm.bi.predict.sa.execution.annotation.result.PredictiveStrengthResult;
import com.ibm.bi.predict.sa.execution.api.messagesgenerator.Caption;
import com.ibm.bi.predict.sa.execution.api.messagesgenerator.MessagesGeneratorCommon;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

class PredictiveStrengthMessages {
    private PredictiveStrengthMessages() {
    }

    static List<Caption> getMessagesForPredictiveStrength(AnnotationResult<?> result, MessageService.MessageBundle messageBundle, Locale locale) {
        String longMessage;
        String shortMessage;
        if (!result.isEmpty() && !(result.getResult() instanceof PredictiveStrengthResult.PredictiveStrengthData)) {
            throw MessagesGeneratorCommon.illegalArgument();
        }
        PredictiveStrengthResult.PredictiveStrengthData predStrengthData = (PredictiveStrengthResult.PredictiveStrengthData)result.getResult();
        if (predStrengthData.hasPredictiveRelationship()) {
            String predictiveStrengthPercent = MessagesGeneratorCommon.formatAsPercentage(predStrengthData.strength, locale);
            String targetFieldName = predStrengthData.targetName;
            String strength = predStrengthData.associationStrengthLevel.name();
            shortMessage = MessagesGeneratorCommon.getShortMessage(messageBundle, "PREDICTIVE_STRENGTH", predictiveStrengthPercent);
            if (predStrengthData.explanatoryNames.size() > 1) {
                String explanatory1Name = predStrengthData.explanatoryNames.get(0);
                String explanatory2Name = predStrengthData.explanatoryNames.get(1);
                longMessage = messageBundle.getMessage("PREDICTIVE_STRENGTH_" + strength + "_LONG_MULTIPLE_FACTORS", explanatory1Name, explanatory2Name, targetFieldName, predictiveStrengthPercent);
            } else {
                String explanatoryName = predStrengthData.explanatoryNames.get(0);
                longMessage = MessagesGeneratorCommon.getLongMessage(messageBundle, "PREDICTIVE_STRENGTH_" + strength, explanatoryName, targetFieldName, predictiveStrengthPercent);
            }
        } else {
            String targetFieldName = predStrengthData.targetName;
            shortMessage = messageBundle.getMessage("PREDICTIVE_STRENGTH_SHORT_NO_RESULTS", new Object[0]);
            if (predStrengthData.explanatoryNames.size() > 1) {
                String explanatory1Name = predStrengthData.explanatoryNames.get(0);
                String explanatory2Name = predStrengthData.explanatoryNames.get(1);
                longMessage = messageBundle.getMessage("PREDICTIVE_STRENGTH_LONG_NO_RESULTS_MULTIPLE_FACTORS", explanatory1Name, explanatory2Name, targetFieldName);
            } else {
                String explanatoryName = predStrengthData.explanatoryNames.get(0);
                longMessage = messageBundle.getMessage("PREDICTIVE_STRENGTH_LONG_NO_RESULTS", explanatoryName, targetFieldName);
            }
        }
        longMessage = MessagesGeneratorCommon.formatLongMessage(longMessage, locale);
        return Arrays.asList(new Caption(shortMessage, longMessage));
    }
}

