/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.utils;

import com.ibm.bi.predict.sa.execution.annotation.ConditionalResponses;
import com.ibm.bi.predict.sa.execution.annotation.response.ConditionalResponse;
import com.ibm.bi.predict.sa.execution.api.DataRowAdapter;
import com.ibm.bi.predict.sa.execution.api.MetaDataAdapter;
import java.util.Optional;

public class RegressionFitUtils {
    private RegressionFitUtils() {
    }

    public static ConditionalResponse validateDataRow(DataRowAdapter dataRow, Optional<Integer> weightIndex, MetaDataAdapter metadata) {
        return weightIndex.map(idx -> RegressionFitUtils.validateWeightValue(dataRow, metadata, idx)).orElse(ConditionalResponses.SUCCESS);
    }

    private static ConditionalResponse validateWeightValue(DataRowAdapter dataRow, MetaDataAdapter metadata, int weightIndex) {
        double weightValue = dataRow.getFieldValueByIndex(weightIndex);
        if (weightValue <= 0.0) {
            return ConditionalResponses.INVALID_DATA_RECORD_WARNING(metadata.getNameOfField(weightIndex));
        }
        return ConditionalResponses.SUCCESS;
    }
}

