/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.suggestion.domain;

import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.exceptions.PredictException;
import com.ibm.bi.predict.sa.suggestion.api.request.AnnotationData;
import com.ibm.bi.predict.sa.suggestion.api.request.AnnotationRequest;
import com.ibm.bi.predict.sa.suggestion.domain.AnnotationDefinition;
import com.ibm.bi.predict.sa.suggestion.domain.MatchingDefinition;
import com.ibm.bi.predict.sa.suggestion.domain.RequirementValidation;
import com.ibm.bi.predict.sa.suggestion.service.AnnotationsGenerator;
import com.ibm.bi.predict.types.DataItem;
import com.ibm.bi.predict.types.RoleType;
import com.ibm.bi.predict.types.Slot;
import com.ibm.bi.predict.types.SlotType;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import com.ibm.bi.predict.utils.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class AnnotationDefinitions {
    private static final Logger logger = PredictLoggerFactory.getLogger(AnnotationsGenerator.class);
    private List<AnnotationDefinition> definitions;
    private Predicate<AnnotationDefinition> isEnabledDefinition = definition -> {
        if (definition.isDisabled()) {
            logger.debug("Skipping disabled annotation definition - definition={}", (Object)definition.getTitle());
        }
        return !definition.isDisabled();
    };

    public List<MatchingDefinition> findMatchingDefinitions(AnnotationRequest request) {
        List<Slot> useFields = this.preProcessUseFields(request);
        if (this.anyAggregationIsUnknown(request)) {
            logger.debug("No matching annotation definitions because of an UNKNOWN aggregation type - numMatched=0");
            return Collections.emptyList();
        }
        List<MatchingDefinition> matching = this.definitions.stream().filter(this.isEnabledDefinition).map(this.matchesRequirements(request, useFields)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        logger.debug("Finished matching annotation definitions against request - numMatched={}", (Object)matching.size());
        return matching;
    }

    private boolean anyAggregationIsUnknown(AnnotationRequest request) {
        return request.getData().stream().flatMap(v -> v.getDataItems().stream()).anyMatch(d -> d.getAggregate() == AggregationType.UNKNOWN);
    }

    private Function<AnnotationDefinition, Optional<MatchingDefinition>> matchesRequirements(AnnotationRequest request, List<Slot> useFields) {
        Map<RoleType, List<Slot>> fieldsGroupedByRole = this.groupFieldsByRole(useFields);
        return definition -> {
            logger.debug("Checking request against annotation definition - definition={}", (Object)definition.getTitle());
            List<RequirementValidation> validations = definition.getRequirements().getValidation();
            ArrayList<Slot> allMatchedFields = new ArrayList<Slot>();
            ArrayList<Tuple<RequirementValidation, List<Slot>>> matched = new ArrayList<Tuple<RequirementValidation, List<Slot>>>();
            if (!this.foundMatchingFields(request, useFields, fieldsGroupedByRole, (AnnotationDefinition)definition, validations, (List<Slot>)allMatchedFields, (List<Tuple<RequirementValidation, List<Slot>>>)matched)) {
                return Optional.empty();
            }
            return this.ensureFieldsAccountedFor(request, useFields, (AnnotationDefinition)definition, (List<Slot>)allMatchedFields, (List<Tuple<RequirementValidation, List<Slot>>>)matched);
        };
    }

    private boolean foundMatchingFields(AnnotationRequest request, List<Slot> useFields, Map<RoleType, List<Slot>> fieldsGroupedByRole, AnnotationDefinition definition, List<RequirementValidation> validations, List<Slot> allMatchedFields, List<Tuple<RequirementValidation, List<Slot>>> matched) {
        for (RequirementValidation validation : validations) {
            Optional<Tuple<RequirementValidation, List<Slot>>> maybeMatchedFields = this.matchesValidation(request, validation, fieldsGroupedByRole);
            if (!maybeMatchedFields.isPresent()) {
                logger.debug("Failed to match request to definition - definition={}, useFields={}", (Object)definition.getTitle(), useFields);
                return false;
            }
            allMatchedFields.addAll((Collection)maybeMatchedFields.get()._2);
            matched.add(maybeMatchedFields.get());
        }
        return true;
    }

    private Optional<MatchingDefinition> ensureFieldsAccountedFor(AnnotationRequest request, List<Slot> useFields, AnnotationDefinition definition, List<Slot> allMatchedFields, List<Tuple<RequirementValidation, List<Slot>>> matched) {
        if (allMatchedFields.containsAll(useFields)) {
            logger.debug("Found matching definition for request - definition={}", (Object)definition.getTitle());
            String datasetId = request.getData().get(0).getId();
            return Optional.of(new MatchingDefinition(definition, matched, datasetId));
        }
        logger.debug("Failed to match request. Not all fields matched against definition - definition={}, useFields={}", (Object)definition.getTitle(), useFields);
        return Optional.empty();
    }

    private Map<RoleType, List<Slot>> groupFieldsByRole(List<Slot> useFields) {
        return useFields.stream().collect(Collectors.groupingBy(Slot::getRole));
    }

    private List<Slot> preProcessUseFields(AnnotationRequest request) {
        boolean hasResponseField = false;
        ArrayList<Slot> processedUseFields = new ArrayList<Slot>();
        for (Slot useField : request.getUse()) {
            Slot modifiedSlot;
            if (this.hasOtherRole(useField) && this.shouldIgnoreOtherField(useField) || useField.getRole() == RoleType.RESPONSE && hasResponseField) continue;
            if (useField.getRole() == RoleType.RESPONSE) {
                hasResponseField = true;
            }
            if ((modifiedSlot = this.determineTypeIfNeeded(useField, request)) == null) continue;
            processedUseFields.add(modifiedSlot);
        }
        return processedUseFields;
    }

    private boolean hasOtherRole(Slot slot) {
        return slot.getRole() == RoleType.OTHER;
    }

    private boolean shouldIgnoreOtherField(Slot useField) {
        String heatSlotName = "Heat";
        return heatSlotName.equals(useField.getName());
    }

    private Slot determineTypeIfNeeded(Slot slot, AnnotationRequest request) {
        boolean typeDefined = slot.getType() == SlotType.CATEGORICAL || slot.getType() == SlotType.CONTINUOUS;
        int itemsInSlot = slot.getDataItems().size();
        if (itemsInSlot == 0) {
            return this.noItemsInSlot(slot, typeDefined);
        }
        if (itemsInSlot > 1) {
            return this.oneItemInSlot(slot);
        }
        if (typeDefined) {
            return slot;
        }
        String dataItemId = (String)slot.getDataItems().get(0);
        DataItem dataItem = this.getDataItemById(dataItemId, request.getData()).orElseThrow(() -> new PredictException("Attempting to get non-existent data item - id=" + dataItemId));
        return this.getSlotFromDataItem(slot, dataItem);
    }

    private Slot getSlotFromDataItem(Slot slot, DataItem dataItem) {
        AggregationType aggregate = dataItem.getAggregate();
        if (aggregate != null && aggregate != AggregationType.NONE) {
            return new Slot(slot.getName(), slot.getDataItems(), SlotType.CONTINUOUS, slot.getRole());
        }
        if (dataItem.getType() != null) {
            SlotType type = dataItem.getType().toSlotType();
            return new Slot(slot.getName(), slot.getDataItems(), type, slot.getRole());
        }
        return new Slot(slot.getName(), slot.getDataItems(), SlotType.CATEGORICAL, slot.getRole());
    }

    private Slot oneItemInSlot(Slot slot) {
        if (slot.getType() != SlotType.CONTINUOUS) {
            if (slot.getType() == SlotType.CATEGORICAL) {
                return slot;
            }
            return new Slot(slot.getName(), slot.getDataItems(), SlotType.CATEGORICAL, slot.getRole());
        }
        logger.warn("A stacked slot had continuous type: slot={}", (Object)slot);
        return null;
    }

    private Slot noItemsInSlot(Slot slot, boolean typeDefined) {
        logger.warn("Slot had zero data items defined: slot={}", (Object)slot);
        if (typeDefined) {
            return slot;
        }
        return new Slot(slot.getName(), slot.getDataItems(), SlotType.CATEGORICAL, slot.getRole());
    }

    private Optional<Tuple<RequirementValidation, List<Slot>>> matchesValidation(AnnotationRequest request, RequirementValidation validation, Map<RoleType, List<Slot>> groupedByRole) {
        RoleType role = RoleType.fromString((String)validation.getRole());
        List fieldsByRole = groupedByRole.getOrDefault(role, Collections.emptyList());
        ArrayList<Slot> matchedFields = new ArrayList<Slot>();
        for (Slot use : fieldsByRole) {
            if (!this.validateType(validation, use) || !this.validateAggregate(validation, request, use)) continue;
            matchedFields.add(use);
        }
        if (this.validateMinMax(matchedFields, validation)) {
            return Optional.of(Tuple.of((Object)validation, matchedFields));
        }
        return Optional.empty();
    }

    private boolean validateType(RequirementValidation validation, Slot use) {
        SlotType actualType = use.getType();
        SlotType expectedType = SlotType.fromString((String)validation.getType());
        if (expectedType == SlotType.ANY) {
            return actualType != null;
        }
        return actualType == expectedType;
    }

    private boolean validateAggregate(RequirementValidation validation, AnnotationRequest request, Slot use) {
        List<String> expectedAggregate = validation.getAggregate();
        String dataItemAggregate = this.getDataItemAggregate(use, request).orElse(null);
        if (expectedAggregate == null && dataItemAggregate != null) {
            return false;
        }
        if (expectedAggregate != null && !expectedAggregate.isEmpty() && !expectedAggregate.contains(dataItemAggregate)) {
            logger.debug("Aggregation type of data item does not match expected type");
            return false;
        }
        return true;
    }

    private boolean validateMinMax(List<Slot> fieldsByRole, RequirementValidation validation) {
        return fieldsByRole.size() >= validation.getMin() && fieldsByRole.size() <= validation.getMax();
    }

    private Optional<String> getDataItemAggregate(Slot use, AnnotationRequest request) {
        String dataItemId = (String)use.getDataItems().get(0);
        Optional<DataItem> dataItem = this.getDataItemById(dataItemId, request.getData());
        return dataItem.map(di -> di.getAggregate() != null ? di.getAggregate().toString() : null);
    }

    private Optional<DataItem> getDataItemById(String id, List<AnnotationData> data) {
        for (AnnotationData d : data) {
            Optional<DataItem> dataItem = d.getDataItems().stream().filter(di -> di.getId().equals(id)).findFirst();
            if (!dataItem.isPresent()) continue;
            return dataItem;
        }
        return Optional.empty();
    }

    public List<AnnotationDefinition> getAnnotations() {
        return this.definitions;
    }

    public void setAnnotations(List<AnnotationDefinition> annotations) {
        this.definitions = annotations;
    }

    public String toString() {
        return Arrays.toString(this.definitions.toArray());
    }
}

