/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.suggestion.domain;

import com.ibm.bi.predict.sa.execution.annotation.MessageService;
import com.ibm.bi.predict.sa.suggestion.domain.Annotation;
import com.ibm.bi.predict.sa.suggestion.domain.Annotations;
import com.ibm.bi.predict.sa.suggestion.domain.parameters.AnnotationParameter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class AnnotationsSerializer {
    static final String ANNOTATIONS_KEY = "annotations";
    static final String CAPTIONS_KEY = "captions";
    static final String TYPE_KEY = "type";
    static final String PARTS_KEY = "parts";
    static final String REQUIREMENTS_KEY = "reqStats";
    static final String DATAITEMS_KEY = "dataItems";
    static final String ROLES_KEY = "roles";
    static final String DATASETID_KEY = "datasetId";
    static final String MODELPARAMETERS_KEY = "modelParameters";

    private AnnotationsSerializer() {
    }

    static JSONObject serialize(Annotations annotations, MessageService.MessageBundle messageBundle) throws JSONException {
        JSONObject result = new JSONObject();
        result.put(ANNOTATIONS_KEY, (Collection)AnnotationsSerializer.serialize(annotations.annotations, messageBundle));
        result.put(CAPTIONS_KEY, (Map)AnnotationsSerializer.serializeCaptions(annotations.captions, messageBundle));
        return result;
    }

    static JSONArray serialize(List<Annotation> annotations, MessageService.MessageBundle messageBundle) throws JSONException {
        JSONArray result = new JSONArray();
        for (Annotation a : annotations) {
            result.add((Object)AnnotationsSerializer.serializeAnnotation(a, messageBundle));
        }
        return result;
    }

    static JSONObject serializeAnnotation(Annotation annotation, MessageService.MessageBundle messageBundle) throws JSONException {
        JSONObject result = new JSONObject();
        result.put(TYPE_KEY, (Object)annotation.getType());
        result.put(PARTS_KEY, (Collection)new JSONArray(annotation.getParts()));
        result.put(REQUIREMENTS_KEY, (Collection)new JSONArray(annotation.getRequirements()));
        result.put(DATAITEMS_KEY, (Collection)new JSONArray(annotation.getDataItems()));
        result.put(ROLES_KEY, (Collection)new JSONArray(annotation.getRoles()));
        result.put(DATASETID_KEY, (Object)annotation.getDatasetId());
        result.put(MODELPARAMETERS_KEY, (Collection)AnnotationsSerializer.serializeParameters(annotation.getModelParameters(), messageBundle));
        return result;
    }

    static JSONArray serializeParameters(List<AnnotationParameter> modelParameters, MessageService.MessageBundle messageBundle) throws JSONException {
        JSONArray result = new JSONArray();
        for (AnnotationParameter opt : modelParameters) {
            result.add((Object)opt.toJSON(messageBundle));
        }
        return result;
    }

    static JSONObject serializeCaptions(Map<String, String> captions, MessageService.MessageBundle messageBundle) throws JSONException {
        JSONObject result = new JSONObject();
        for (Map.Entry<String, String> e : captions.entrySet()) {
            result.put(e.getKey(), (Object)e.getValue());
        }
        return result;
    }
}

