/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.suggestion.domain;

import com.ibm.bi.predict.sa.suggestion.domain.AnnotationDefinition;
import com.ibm.bi.predict.sa.suggestion.domain.RequirementValidation;
import com.ibm.bi.predict.types.RoleType;
import com.ibm.bi.predict.types.Slot;
import com.ibm.bi.predict.utils.Tuple;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class MatchingDefinition {
    private List<Tuple<RequirementValidation, List<Slot>>> matchingFields;
    private AnnotationDefinition definition;
    private String datasetId;

    public MatchingDefinition(AnnotationDefinition definition, List<Tuple<RequirementValidation, List<Slot>>> matchingFields, String datasetId) {
        this.definition = definition;
        this.matchingFields = MatchingDefinition.copySlotsOf(matchingFields);
        this.datasetId = datasetId;
    }

    private static List<Tuple<RequirementValidation, List<Slot>>> copySlotsOf(List<Tuple<RequirementValidation, List<Slot>>> matchingFields) {
        return matchingFields.stream().map(tuple -> new Tuple(tuple._1, MatchingDefinition.copySlotList((List)tuple._2))).collect(Collectors.toList());
    }

    private static List<Slot> copySlotList(List<Slot> inputList) {
        return inputList.stream().map(slot -> new Slot(slot.getName(), slot.getDataItems(), slot.getType(), slot.getRole())).collect(Collectors.toList());
    }

    public AnnotationDefinition getDefinition() {
        return this.definition;
    }

    public List<Tuple<RequirementValidation, List<Slot>>> getMatchingFields() {
        return this.matchingFields;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public List<String> getDataItemsOfMatchedFields() {
        return this.getMatchingFields().stream().flatMap(t -> ((List)t._2).stream()).map(Slot::getDataItems).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<String> getRolesOfMatchingFields() {
        List<String> roles = this.getMatchingFields().stream().flatMap(matchingField -> this.swapRolesIfNeeded((Tuple<RequirementValidation, List<Slot>>)matchingField).stream()).map(Slot::getRole).map(Object::toString).collect(Collectors.toList());
        return roles;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.matchingFields).append((Object)this.definition).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MatchingDefinition)) {
            return false;
        }
        MatchingDefinition other = (MatchingDefinition)MatchingDefinition.class.cast(obj);
        return new EqualsBuilder().append(this.matchingFields, other.matchingFields).append((Object)this.definition, (Object)other.definition).isEquals();
    }

    private List<Slot> swapRolesIfNeeded(Tuple<RequirementValidation, List<Slot>> matchingField) {
        if (this.rolesNeedSwapped(matchingField)) {
            RequirementValidation validation = (RequirementValidation)matchingField._1;
            List fields = (List)matchingField._2;
            RoleType newRole = RoleType.fromString((String)validation.getTreatAs());
            if (!fields.isEmpty()) {
                ((Slot)fields.get(0)).setRole(newRole);
            }
        }
        return (List)matchingField._2;
    }

    private boolean rolesNeedSwapped(Tuple<RequirementValidation, List<Slot>> matchingField) {
        RequirementValidation validation = (RequirementValidation)matchingField._1;
        return validation.getTreatAs() != null;
    }
}

