/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.suggestion.rules;

import com.google.common.collect.Lists;
import com.ibm.bi.predict.sa.suggestion.domain.Annotation;
import com.ibm.bi.predict.sa.suggestion.rules.Rules;
import com.ibm.bi.predict.sa.suggestion.rules.domain.MatchedInsight;
import com.ibm.bi.predict.sa.suggestion.rules.domain.RuleAlgorithm;
import com.ibm.bi.predict.sa.suggestion.rules.domain.RuleInsightType;
import com.ibm.bi.predict.sa.suggestion.rules.domain.RuleRequiredStatistics;
import com.ibm.bi.predict.sa.suggestion.rules.domain.RuleSlot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MatchedInsightMapper {
    private MatchedInsightMapper() {
    }

    public static List<Annotation> toAnnotations(List<MatchedInsight> matched) {
        return matched.stream().map(MatchedInsightMapper::toAnnotations).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    public static List<Annotation> toAnnotations(MatchedInsight matched) {
        ArrayList<Annotation> ann = new ArrayList<Annotation>();
        List<RuleSlot> matchedSlots = matched.slots();
        List<String> slotDataItems = matchedSlots.stream().flatMap(s -> s.slot().getDataItems().stream()).collect(Collectors.toList());
        List<String> roles = matchedSlots.stream().map(s -> s.slot().getRole().toString()).collect(Collectors.toList());
        for (Map.Entry<RuleInsightType, List<String>> algorithm : matched.insight().algorithms().entrySet()) {
            List<String> algorithmIds = algorithm.getValue();
            for (String algoId : algorithmIds) {
                RuleAlgorithm algo = Rules.algorithm(algoId);
                ann.add(new Annotation(algo.insightType().toString(), Lists.newArrayList((Object[])new String[]{algo.name()}), MatchedInsightMapper.requiredStatisticsForAlgorithm(algo), slotDataItems, roles, matched.dataSetId(), algo.modelOptions()));
            }
        }
        return ann;
    }

    private static Set<String> requiredStatisticsForAlgorithm(RuleAlgorithm algorithm) {
        return algorithm.getRequiredStatistics().stream().map(RuleRequiredStatistics::getName).collect(Collectors.toSet());
    }
}

